/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import javajs.util.A4;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.P3;
import javajs.util.Quat;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.c.STR;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelsetbio.BasePair;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.NucleicPolymer;
import org.jmol.modelsetbio.PhosphorusMonomer;
import org.jmol.viewer.Viewer;

public class NucleicMonomer
extends PhosphorusMonomer {
    static final byte C6 = 1;
    private static final byte O2Pr = 2;
    private static final byte C5 = 3;
    private static final byte N1 = 4;
    private static final byte C2 = 5;
    private static final byte N3 = 6;
    private static final byte C4 = 7;
    private static final byte O2 = 8;
    private static final byte N7 = 9;
    private static final byte C8 = 10;
    private static final byte N9 = 11;
    private static final byte O4 = 12;
    private static final byte O6 = 13;
    private static final byte N4 = 14;
    private static final byte NP = 15;
    private static final byte N6 = 16;
    private static final byte N2 = 17;
    private static final byte H5T = 18;
    private static final byte O5P = 19;
    private static final byte H3T = 20;
    private static final byte O3P = 21;
    private static final byte C3P = 22;
    private static final byte O1P = 23;
    private static final byte O2P = 24;
    private static final byte C1P = 25;
    private static final byte C2P = 26;
    private static final byte C4P = 27;
    private static final byte O4P = 28;
    private static final byte C5P = 29;
    static final byte[] interestingNucleicAtomIDs = new byte[]{-14, 37, -80, 36, 32, 33, 34, 35, -39, -40, -41, -42, -48, -47, -43, -14, -45, -44, -73, -7, -89, 10, 9, -75, -77, -13, -12, -9, -79, -8};
    private boolean isPurine;
    boolean isPyrimidine;
    private boolean hasRnaO2Prime;
    private static final byte[] ring6OffsetIndexes = new byte[]{3, 1, 4, 5, 6, 7};
    private static final byte[] ring5OffsetIndexes = new byte[]{3, 9, 10, 11, 7};
    private static final byte[] riboseOffsetIndexes = new byte[]{25, 26, 22, 27, 28, 21, 29, 19, 0};
    private static final byte[] heavyAtomIndexes = new byte[]{3, 1, 4, 5, 6, 7, 11, 10, 9, 16, 14, 8, 12, 17, 13};
    P3 baseCenter;
    private Lst<BasePair> bps;
    public P3[] dssrBox;
    public float dssrBoxHeight;
    public P3[] dssrFrame;

    private NucleicMonomer() {
    }

    public static Monomer validateAndAllocate(Chain chain, String group3, int seqcode, int firstAtomIndex, int lastAtomIndex, int[] specialAtomIndexes) {
        byte[] offsets = NucleicMonomer.scanForOffsets(firstAtomIndex, specialAtomIndexes, interestingNucleicAtomIDs);
        if (offsets == null) {
            return null;
        }
        if (!NucleicMonomer.checkOptional(offsets, (byte)19, firstAtomIndex, specialAtomIndexes[73])) {
            return null;
        }
        NucleicMonomer.checkOptional(offsets, (byte)20, firstAtomIndex, specialAtomIndexes[89]);
        NucleicMonomer.checkOptional(offsets, (byte)18, firstAtomIndex, specialAtomIndexes[90]);
        NucleicMonomer.checkOptional(offsets, (byte)23, firstAtomIndex, specialAtomIndexes[75]);
        NucleicMonomer.checkOptional(offsets, (byte)24, firstAtomIndex, specialAtomIndexes[77]);
        return new NucleicMonomer().set4(chain, group3, seqcode, firstAtomIndex, lastAtomIndex, offsets);
    }

    private NucleicMonomer set4(Chain chain, String group3, int seqcode, int firstAtomIndex, int lastAtomIndex, byte[] offsets) {
        this.set2(chain, group3, seqcode, firstAtomIndex, lastAtomIndex, offsets);
        if (!NucleicMonomer.have(offsets, (byte)15)) {
            offsets[0] = offsets[19];
            this.setLeadAtomIndex();
        }
        this.hasRnaO2Prime = NucleicMonomer.have(offsets, (byte)2);
        this.isPyrimidine = NucleicMonomer.have(offsets, (byte)8);
        this.isPurine = NucleicMonomer.have(offsets, (byte)9) && NucleicMonomer.have(offsets, (byte)10) && NucleicMonomer.have(offsets, (byte)11);
        return this;
    }

    public boolean isNucleicMonomer() {
        return true;
    }

    @Override
    public boolean isDna() {
        return !this.hasRnaO2Prime;
    }

    @Override
    public boolean isRna() {
        return this.hasRnaO2Prime;
    }

    @Override
    public boolean isPurine() {
        return this.isPurine || !this.isPyrimidine && this.isPurineByID();
    }

    @Override
    public boolean isPyrimidine() {
        return this.isPyrimidine || !this.isPurine && this.isPyrimidineByID();
    }

    public boolean isGuanine() {
        return NucleicMonomer.have(this.offsets, (byte)17);
    }

    @Override
    public STR getProteinStructureType() {
        return this.hasRnaO2Prime ? STR.RNA : STR.DNA;
    }

    Atom getP() {
        return this.getAtomFromOffsetIndex(0);
    }

    public Atom getC1P() {
        return this.getAtomFromOffsetIndex(25);
    }

    Atom getC2() {
        return this.getAtomFromOffsetIndex(5);
    }

    Atom getC5() {
        return this.getAtomFromOffsetIndex(3);
    }

    Atom getC6() {
        return this.getAtomFromOffsetIndex(1);
    }

    Atom getC8() {
        return this.getAtomFromOffsetIndex(10);
    }

    Atom getC4P() {
        return this.getAtomFromOffsetIndex(27);
    }

    Atom getN1() {
        return this.getAtomFromOffsetIndex(4);
    }

    public Atom getN3() {
        return this.getAtomFromOffsetIndex(6);
    }

    Atom getN2() {
        return this.getAtomFromOffsetIndex(17);
    }

    Atom getN4() {
        return this.getAtomFromOffsetIndex(14);
    }

    Atom getN6() {
        return this.getAtomFromOffsetIndex(16);
    }

    Atom getO2() {
        return this.getAtomFromOffsetIndex(8);
    }

    Atom getO4() {
        return this.getAtomFromOffsetIndex(12);
    }

    Atom getO6() {
        return this.getAtomFromOffsetIndex(13);
    }

    @Override
    Atom getTerminatorAtom() {
        return this.getAtomFromOffsetIndex(NucleicMonomer.have(this.offsets, (byte)20) ? 20 : 21);
    }

    public void getBaseRing6Points(P3[] pts) {
        this.getPoints(ring6OffsetIndexes, pts);
    }

    private void getPoints(byte[] a, P3[] pts) {
        int i = a.length;
        while (--i >= 0) {
            pts[i] = this.getAtomFromOffsetIndex(a[i]);
        }
    }

    public boolean maybeGetBaseRing5Points(P3[] pts) {
        if (this.isPurine) {
            this.getPoints(ring5OffsetIndexes, pts);
        }
        return this.isPurine;
    }

    public void getRiboseRing5Points(P3[] pts) {
        this.getPoints(riboseOffsetIndexes, pts);
    }

    @Override
    boolean isConnectedAfter(Monomer possiblyPreviousMonomer) {
        if (possiblyPreviousMonomer == null) {
            return true;
        }
        Atom myPhosphorusAtom = this.getAtomFromOffsetIndex(15);
        if (myPhosphorusAtom == null) {
            return false;
        }
        return ((NucleicMonomer)possiblyPreviousMonomer).getAtomFromOffsetIndex(21).isBonded(myPhosphorusAtom) || this.isCA2(possiblyPreviousMonomer);
    }

    @Override
    public void findNearestAtomIndex(int x, int y, Atom[] closest, short madBegin, short madEnd) {
        int radius;
        Atom competitor = closest[0];
        Atom lead = this.getLeadAtom();
        Atom o5prime = this.getAtomFromOffsetIndex(19);
        Atom c3prime = this.getAtomFromOffsetIndex(22);
        int mar = madBegin / 2;
        if (mar < 1900) {
            mar = 1900;
        }
        if ((radius = (int)this.scaleToScreen(lead.sZ, mar)) < 4) {
            radius = 4;
        }
        if (this.isCursorOnTopOf(lead, x, y, radius, competitor) || this.isCursorOnTopOf(o5prime, x, y, radius, competitor) || this.isCursorOnTopOf(c3prime, x, y, radius, competitor)) {
            closest[0] = lead;
        }
    }

    public void setRingsVisible(boolean isVisible) {
        int i = 6;
        while (--i >= 0) {
            this.getAtomFromOffsetIndex(ring6OffsetIndexes[i]).setShapeVisibility(32768, isVisible);
        }
        if (this.isPurine) {
            i = 4;
            while (--i >= 1) {
                this.getAtomFromOffsetIndex(ring5OffsetIndexes[i]).setShapeVisibility(32768, isVisible);
            }
        }
    }

    public void setRingsClickable() {
        int i = 6;
        while (--i >= 0) {
            this.getAtomFromOffsetIndex(ring6OffsetIndexes[i]).setClickable(32768);
        }
        if (this.isPurine) {
            i = 4;
            while (--i >= 1) {
                this.getAtomFromOffsetIndex(ring5OffsetIndexes[i]).setClickable(32768);
            }
        }
    }

    public Atom getN0() {
        return this.getAtomFromOffsetIndex(this.isPurine ? 11 : 4);
    }

    @Override
    public Object getHelixData(int tokType, char qType, int mStep) {
        return this.getHelixData2(tokType, qType, mStep);
    }

    @Override
    P3 getQuaternionFrameCenter(char qType) {
        switch (qType) {
            case 'a': 
            case 'b': 
            case 'p': 
            case 'x': {
                return this.getP();
            }
            case 'c': {
                if (this.baseCenter == null) {
                    int n = 0;
                    this.baseCenter = new P3();
                    for (int i = 0; i < heavyAtomIndexes.length; ++i) {
                        Atom a = this.getAtomFromOffsetIndex(heavyAtomIndexes[i]);
                        if (a == null) continue;
                        this.baseCenter.add((T3)a);
                        ++n;
                    }
                    this.baseCenter.scale(1.0f / (float)n);
                }
                return this.baseCenter;
            }
        }
        return this.getN0();
    }

    @Override
    public Quat getQuaternion(char qType) {
        Atom ptNorP;
        if (this.bioPolymer == null) {
            return null;
        }
        Atom ptA = null;
        Atom ptB = null;
        boolean yBased = false;
        boolean reverseY = false;
        switch (qType) {
            case 'a': {
                ptNorP = this.getP();
                if (this.monomerIndex == 0 || ptNorP == null) {
                    return null;
                }
                yBased = true;
                ptA = ((NucleicMonomer)this.bioPolymer.monomers[this.monomerIndex - 1]).getC4P();
                ptB = this.getC4P();
                break;
            }
            case 'x': {
                ptNorP = this.getP();
                if (this.monomerIndex == this.bioPolymer.monomerCount - 1 || ptNorP == null) {
                    return null;
                }
                ptA = ((NucleicMonomer)this.bioPolymer.monomers[this.monomerIndex + 1]).getP();
                ptB = this.getC4P();
                break;
            }
            case 'b': {
                return this.getQuaternionP();
            }
            case 'c': 
            case 'n': {
                ptNorP = this.getN0();
                if (ptNorP == null) {
                    return null;
                }
                yBased = true;
                reverseY = true;
                ptA = this.getAtomFromOffsetIndex(5);
                ptB = this.getAtomFromOffsetIndex(25);
                break;
            }
            case 'p': {
                ptNorP = this.getP();
                if (ptNorP == null) {
                    return null;
                }
                Atom p1 = this.getAtomFromOffsetIndex(23);
                Atom p2 = this.getAtomFromOffsetIndex(24);
                Bond[] bonds = ptNorP.bonds;
                if (bonds == null) {
                    return null;
                }
                Group g = ptNorP.group;
                for (int i = 0; i < bonds.length; ++i) {
                    Atom atom = bonds[i].getOtherAtom(ptNorP);
                    if (p1 != null && atom.i == p1.i || p2 != null && atom.i == p2.i) continue;
                    if (atom.group == g) {
                        ptB = atom;
                        continue;
                    }
                    ptA = atom;
                }
                break;
            }
            case 'q': {
                return null;
            }
            default: {
                ptNorP = this.getN0();
                if (ptNorP == null) {
                    return null;
                }
                if (this.isPurine) {
                    ptA = this.getAtomFromOffsetIndex(5);
                    ptB = this.getAtomFromOffsetIndex(9);
                    break;
                }
                ptA = this.getAtomFromOffsetIndex(6);
                ptB = this.getAtomFromOffsetIndex(1);
            }
        }
        if (ptA == null || ptB == null) {
            return null;
        }
        V3 vA = V3.newVsub((T3)ptA, (T3)ptNorP);
        V3 vB = V3.newVsub((T3)ptB, (T3)ptNorP);
        if (reverseY) {
            vB.scale(-1.0f);
        }
        return Quat.getQuaternionFrameV((V3)vA, (V3)vB, null, (boolean)yBased);
    }

    @Override
    public boolean isCrossLinked(Group g) {
        if (!(g instanceof NucleicMonomer) || this.isPurine == g.isPurine()) {
            return false;
        }
        NucleicMonomer otherNucleotide = this.isPurine ? (NucleicMonomer)g : this;
        NucleicMonomer myNucleotide = this.isPurine ? this : (NucleicMonomer)g;
        Atom myN1 = myNucleotide.getN1();
        Atom otherN3 = otherNucleotide.getN3();
        return myN1.isBonded(otherN3);
    }

    @Override
    public boolean getCrossLinkVector(Lst<Integer> vReturn, boolean crosslinkCovalent, boolean crosslinkHBond) {
        if (!crosslinkHBond) {
            return false;
        }
        Atom N = this.isPurine ? this.getN1() : this.getN3();
        Bond[] bonds = N.bonds;
        if (bonds == null) {
            return false;
        }
        for (int i = 0; i < bonds.length; ++i) {
            if (!bonds[i].isHydrogen()) continue;
            Atom N2 = bonds[i].getOtherAtom(N);
            Group g = N2.group;
            if (!(g instanceof NucleicMonomer)) continue;
            NucleicMonomer m = (NucleicMonomer)g;
            if ((this.isPurine ? m.getN3() : m.getN1()) != N2) continue;
            if (vReturn == null) {
                return true;
            }
            vReturn.addLast((Object)N.i);
            vReturn.addLast((Object)N2.i);
            vReturn.addLast((Object)m.leadAtomIndex);
        }
        return vReturn != null && vReturn.size() > 0;
    }

    public boolean getEdgePoints(P3[] pts) {
        pts[0] = this.getLeadAtom();
        pts[1] = this.getC4P();
        pts[2] = pts[5] = this.getC1P();
        switch (this.getGroup1()) {
            case 'C': {
                pts[3] = this.getO2();
                pts[4] = this.getN4();
                return true;
            }
            case 'A': {
                pts[3] = this.getC2();
                pts[4] = this.getN6();
                return true;
            }
            case 'G': 
            case 'I': {
                pts[3] = this.getC2();
                pts[4] = this.getO6();
                return true;
            }
            case 'T': 
            case 'U': {
                pts[3] = this.getO2();
                pts[4] = this.getO4();
                return true;
            }
        }
        return false;
    }

    public void addBasePair(BasePair bp) {
        if (this.bps == null) {
            this.bps = new Lst();
        }
        this.bps.addLast((Object)bp);
    }

    public void setGroup1(char g) {
        if (this.group1 == '\u0000') {
            this.group1 = g;
        }
    }

    public Lst<BasePair> getBasePairs() {
        if (this.bioPolymer != null && !((NucleicPolymer)this.bioPolymer).isDssrSet) {
            this.bioPolymer.model.ms.vwr.getAnnotationParser(true).getBasePairs(this.bioPolymer.model.ms.vwr, this.bioPolymer.model.modelIndex);
        }
        return this.bps;
    }

    @Override
    protected char getGroup1b() {
        String g3 = Group.group3Names[this.groupID];
        String g1 = NucleicPolymer.htGroup1 == null ? null : NucleicPolymer.htGroup1.get(g3);
        return g1 == null ? Character.toLowerCase(g3.charAt(g3.length() - 1)) : g1.charAt(0);
    }

    public P3[] getDSSRFrame(Viewer vwr) {
        if (this.dssrFrame != null) {
            return this.dssrFrame;
        }
        if (this.dssrNT != null) {
            this.dssrFrame = vwr.getAnnotationParser(true).getDSSRFrame(this.dssrNT);
            return this.dssrFrame;
        }
        this.dssrFrame = new P3[4];
        P3[] oxyz = this.dssrFrame;
        int i = 4;
        while (--i >= 0) {
            oxyz[i] = new P3();
        }
        if (this.isPurine()) {
            P3 v85 = P3.newP((T3)this.getC5());
            v85.sub((T3)this.getC8());
            v85.normalize();
            oxyz[2].setT((T3)v85);
            oxyz[2].scale(-1.0f);
            oxyz[0].scaleAdd2(4.9f, (T3)v85, (T3)this.getC8());
            P3 v89 = P3.newP((T3)this.getN0());
            v89.sub((T3)this.getC8());
            oxyz[3].cross((T3)v89, (T3)v85);
            oxyz[3].normalize();
        } else {
            P3 v61 = P3.newP((T3)this.getN0());
            v61.sub((T3)this.getC6());
            P3 v65 = P3.newP((T3)this.getC5());
            v65.sub((T3)this.getC6());
            oxyz[3].cross((T3)v61, (T3)v65);
            oxyz[3].normalize();
            oxyz[2].setT((T3)v61);
            oxyz[2].normalize();
            A4 aa = A4.new4((float)oxyz[3].x, (float)oxyz[3].y, (float)oxyz[3].z, (float)1.1623893f);
            M3 m3 = new M3();
            m3.setAA(aa);
            m3.rotate((T3)oxyz[2]);
            oxyz[0].scaleAdd2(5.1f, (T3)oxyz[2], (T3)this.getC6());
            oxyz[2].scale(-1.0f);
        }
        oxyz[1].cross((T3)oxyz[2], (T3)oxyz[3]);
        return this.dssrFrame;
    }
}

