/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.Measure;
import javajs.util.P4;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.HBond;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.NucleicMonomer;
import org.jmol.modelsetbio.PhosphorusPolymer;

public class NucleicPolymer
extends PhosphorusPolymer {
    public boolean isDssrSet;
    public static Map<String, String> htGroup1;

    NucleicPolymer(Monomer[] monomers) {
        super(monomers);
        this.type = 2;
        this.hasWingPoints = true;
    }

    Atom getNucleicPhosphorusAtom(int monomerIndex) {
        return this.monomers[monomerIndex].getLeadAtom();
    }

    @Override
    protected boolean calcEtaThetaAngles() {
        float eta = Float.NaN;
        for (int i = 0; i < this.monomerCount - 2; ++i) {
            NucleicMonomer m1 = (NucleicMonomer)this.monomers[i];
            NucleicMonomer m2 = (NucleicMonomer)this.monomers[i + 1];
            Atom p1 = m1.getP();
            Atom c41 = m1.getC4P();
            Atom p2 = m2.getP();
            Atom c42 = m2.getC4P();
            if (i > 0) {
                NucleicMonomer m0 = (NucleicMonomer)this.monomers[i - 1];
                Atom c40 = m0.getC4P();
                eta = Measure.computeTorsion((T3)c40, (T3)p1, (T3)c41, (T3)p2, (boolean)true);
            }
            float theta = Measure.computeTorsion((T3)p1, (T3)c41, (T3)p2, (T3)c42, (boolean)true);
            if (eta < 0.0f) {
                eta += 360.0f;
            }
            if (theta < 0.0f) {
                theta += 360.0f;
            }
            m1.setGroupParameter(1111490565, eta);
            m1.setGroupParameter(1111490576, theta);
        }
        return true;
    }

    @Override
    public void calcRasmolHydrogenBonds(BioPolymer polymer, BS bsA, BS bsB, Lst<Bond> vAtoms, int nMaxPerResidue, int[][][] min, boolean checkDistances, boolean dsspIgnoreHydrogens) {
        NucleicPolymer other = (NucleicPolymer)polymer;
        V3 vNorm = new V3();
        V3 vAB = new V3();
        int i = this.monomerCount;
        while (--i >= 0) {
            NucleicMonomer myNucleotide = (NucleicMonomer)this.monomers[i];
            if (!myNucleotide.isPurine()) continue;
            Atom myN3 = myNucleotide.getN3();
            boolean isInA = bsA.get(myN3.i);
            if (!isInA && !bsB.get(myN3.i)) continue;
            Atom myN1 = myNucleotide.getN1();
            Atom myN9 = myNucleotide.getN0();
            P4 plane = Measure.getPlaneThroughPoints((T3)myN3, (T3)myN1, (T3)myN9, (V3)vNorm, (V3)vAB, (P4)new P4());
            Atom bestN3 = null;
            float minDist2 = 25.0f;
            NucleicMonomer bestNucleotide = null;
            int j = other.monomerCount;
            while (--j >= 0) {
                NucleicMonomer otherNucleotide = (NucleicMonomer)other.monomers[j];
                if (!otherNucleotide.isPyrimidine) continue;
                Atom otherN3 = otherNucleotide.getN3();
                if (isInA ? !bsB.get(otherN3.i) : !bsA.get(otherN3.i)) continue;
                Atom otherN1 = otherNucleotide.getN0();
                float dist2 = myN1.distanceSquared((T3)otherN3);
                if (!(dist2 < minDist2) || !(myN9.distanceSquared((T3)otherN1) > 50.0f) || !(Math.abs(Measure.distanceToPlane((P4)plane, (T3)otherN3)) < 1.0f)) continue;
                bestNucleotide = otherNucleotide;
                bestN3 = otherN3;
                minDist2 = dist2;
            }
            int n = 0;
            if (bestN3 == null || (n += NucleicPolymer.addHydrogenBond(vAtoms, myN1, bestN3)) >= nMaxPerResidue) continue;
            if (myNucleotide.isGuanine()) {
                if ((n += NucleicPolymer.addHydrogenBond(vAtoms, myNucleotide.getN2(), bestNucleotide.getO2())) >= nMaxPerResidue || (n += NucleicPolymer.addHydrogenBond(vAtoms, myNucleotide.getO6(), bestNucleotide.getN4())) < nMaxPerResidue) continue;
                continue;
            }
            n += NucleicPolymer.addHydrogenBond(vAtoms, myNucleotide.getN6(), bestNucleotide.getO4());
        }
    }

    protected static int addHydrogenBond(Lst<Bond> vAtoms, Atom atom1, Atom atom2) {
        if (atom1 == null || atom2 == null) {
            return 0;
        }
        vAtoms.addLast((Object)new HBond(atom1, atom2, 18432, 1, 0, 0.0f));
        return 1;
    }
}

