/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.quantum;

import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Eigen;
import javajs.util.T3;
import org.jmol.jvxl.data.VolumeData;
import org.jmol.quantum.QuantumPlaneCalculation;
import org.jmol.util.BSUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;

public class NciCalculation
extends QuantumPlaneCalculation {
    private boolean havePoints;
    private boolean isReducedDensity;
    private double DEFAULT_RHOPLOT_SCF = 0.05;
    private double DEFAULT_RHOPLOT_PRO = 0.07;
    private double DEFAULT_RHOPARAM = 0.95;
    private double rhoMin;
    private double rhoPlot;
    private double rhoParam;
    private static final int TYPE_ALL = 0;
    private static final int TYPE_INTRA = 1;
    private static final int TYPE_INTER = 2;
    private static final int TYPE_LIGAND = 3;
    private static final double NO_VALUE = 100.0;
    private float dataScaling = 1.0f;
    private boolean dataIsReducedDensity;
    private Eigen eigen;
    private double[] rhoMolecules;
    private int type;
    private int nMolecules;
    private boolean isPromolecular;
    private BS bsOK;
    private boolean noValuesAtAll;
    private boolean useAbsolute;
    private static double c = 1.0 / (2.0 * Math.pow(29.608813203268074, 0.3333333333333333));
    private static double rpower = -1.3333333333333333;
    private double[][] hess;
    private double grad;
    private double gxTemp;
    private double gyTemp;
    private double gzTemp;
    private double gxxTemp;
    private double gyyTemp;
    private double gzzTemp;
    private double gxyTemp;
    private double gyzTemp;
    private double gxzTemp;
    private float[] eigenValues = new float[3];
    double test1;
    private float[][] yzPlanesRaw;
    private int yzCount;
    private float[][] yzPlanesRho = AU.newFloat2((int)2);
    private float[] p0;
    private float[] p1;
    private float[] p2;
    private static double[] coef1 = new double[]{0.0, 0.2815, 2.437, 11.84, 31.34, 67.82, 120.2, 190.9, 289.5, 406.3, 561.3, 760.8, 1016.0, 1319.0, 1658.0, 2042.0, 2501.0, 3024.0, 3625.0};
    private static double[] coef2 = new double[]{0.0, 0.0, 0.0, 0.06332, 0.3694, 0.8527, 1.172, 2.247, 2.879, 3.049, 6.984, 22.42, 37.17, 57.95, 87.16, 115.7, 158.0, 205.5, 260.0};
    private static double[] coef3 = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.06358, 0.3331, 0.8878, 0.7888, 1.465, 2.17, 3.369, 5.211};
    private static double[] zeta1 = new double[]{0.0, 0.5288, 0.3379, 0.1912, 0.139, 0.1059, 0.0884, 0.0767, 0.0669, 0.0608, 0.0549, 0.0496, 0.0449, 0.0411, 0.0382, 0.0358, 0.0335, 0.0315, 0.0296};
    private static double[] zeta2 = new double[]{0.0, 1.0, 1.0, 0.9992, 0.6945, 0.53, 0.548, 0.4532, 0.3974, 0.3994, 0.3447, 0.2511, 0.215, 0.1874, 0.1654, 0.1509, 0.1369, 0.1259, 0.1168};
    private static double[] zeta3 = new double[]{0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0236, 0.7753, 0.5962, 0.6995, 0.5851, 0.5149, 0.4974, 0.4412};
    private static double[] dMax = new double[]{0.0, 2.982502423, 2.635120936, 4.144887422, 4.105800759, 3.576656363, 3.872424373, 3.497503547, 3.165369971, 3.204214082, 3.051069564, 4.251312809, 4.503309314, 4.047465141, 4.666024968, 4.265151411, 3.955710076, 4.040067606, 3.776022242};

    @Override
    public float getNoValue() {
        return 100.0f;
    }

    public boolean setupCalculation(VolumeData volumeData, BS bsSelected, BS bsExcluded, BS[] bsMolecules, T3[] atomCoordAngstroms, int firstAtomOffset, boolean isReducedDensity, T3[] points, float[] parameters, int testFlags) {
        String stype;
        this.useAbsolute = testFlags == 2;
        this.bsExcluded = bsExcluded;
        BS bsLigand = new BS();
        bsLigand.or(bsSelected);
        if (bsExcluded != null) {
            bsLigand.andNot(bsExcluded);
        }
        this.isPromolecular = firstAtomOffset >= 0;
        this.havePoints = points != null;
        this.isReducedDensity = isReducedDensity;
        if (parameters != null) {
            Logger.info((String)("NCI calculation parameters = " + Escape.eAF((float[])parameters)));
        }
        this.type = (int)NciCalculation.getParameter(parameters, 1, 0.0, "type");
        if (this.type != 0 && bsMolecules == null) {
            this.type = 0;
        }
        this.rhoMin = NciCalculation.getParameter(parameters, 2, 1.0E-5, "rhoMin");
        this.rhoPlot = NciCalculation.getParameter(parameters, 3, this.isPromolecular ? this.DEFAULT_RHOPLOT_PRO : this.DEFAULT_RHOPLOT_SCF, "rhoPlot");
        this.rhoParam = NciCalculation.getParameter(parameters, 4, this.DEFAULT_RHOPARAM, "rhoParam");
        this.dataScaling = (float)NciCalculation.getParameter(parameters, 5, 1.0, "dataScaling");
        this.dataIsReducedDensity = this.type < 0;
        switch (this.type) {
            default: {
                this.type = 0;
                stype = "all";
                bsMolecules = null;
                break;
            }
            case -1: 
            case 1: {
                this.type = 1;
                stype = "intramolecular";
                break;
            }
            case -2: 
            case 2: {
                this.type = 2;
                stype = "intermolecular";
                break;
            }
            case 3: {
                stype = "ligand";
            }
        }
        this.nMolecules = 0;
        if (!this.isPromolecular && this.type == 0) {
            atomCoordAngstroms = null;
        }
        Logger.info((String)("NCI calculation type = " + (this.isPromolecular ? "promolecular " : "SCF(CUBE) ") + stype));
        this.voxelData = volumeData.getVoxelData();
        this.countsXYZ = volumeData.getVoxelCounts();
        this.initialize(this.countsXYZ[0], this.countsXYZ[1], this.countsXYZ[2], points);
        if (this.havePoints) {
            this.zMin = 0;
            this.yMin = 0;
            this.xMin = 0;
            this.yMax = this.zMax = points.length;
            this.xMax = this.zMax;
        }
        this.setupCoordinates(volumeData.getOriginFloat(), volumeData.getVolumetricVectorLengths(), bsSelected, atomCoordAngstroms, null, points, true);
        if (this.qmAtoms != null) {
            int[] qmMap = new int[bsSelected.length()];
            int i = this.qmAtoms.length;
            while (--i >= 0) {
                qmMap[this.qmAtoms[i].index] = i;
                if (this.qmAtoms[i].znuc < 1) {
                    this.qmAtoms[i] = null;
                    continue;
                }
                if (this.qmAtoms[i].znuc <= 18) continue;
                this.qmAtoms[i].znuc = 18;
                Logger.info((String)("NCI calculation just setting nuclear charge for " + this.qmAtoms[i].atom + " to 18 (argon)"));
            }
            this.nMolecules = 0;
            if (this.type != 0) {
                for (i = 0; i < bsMolecules.length; ++i) {
                    BS bs = BSUtil.copy((BS)bsMolecules[i]);
                    bs.and(bsSelected);
                    if (bs.nextSetBit(0) < 0) continue;
                    int j = bs.nextSetBit(0);
                    while (j >= 0) {
                        this.qmAtoms[qmMap[j]].iMolecule = this.nMolecules;
                        j = bs.nextSetBit(j + 1);
                    }
                    ++this.nMolecules;
                    Logger.info((String)("Molecule " + this.nMolecules + " (" + bs.cardinality() + " atoms): " + Escape.eBS((BS)bs)));
                }
                this.rhoMolecules = new double[this.nMolecules];
            }
            if (this.nMolecules == 0) {
                this.nMolecules = 1;
            }
            if (this.nMolecules == 1) {
                this.noValuesAtAll = this.type != 0 && this.type != 1;
                this.type = 0;
            }
            if (!this.isPromolecular) {
                this.getBsOK();
            }
        }
        if (!isReducedDensity || !this.isPromolecular) {
            this.initializeEigen();
        }
        this.doDebug = Logger.debugging;
        return true;
    }

    private static double getParameter(float[] parameters, int i, double def, String name) {
        double param = parameters == null || parameters.length < i + 1 ? 0.0f : parameters[i];
        if (param == 0.0) {
            param = def;
        }
        Logger.info((String)("NCI calculation parameters[" + i + "] (" + name + ") = " + param));
        return param;
    }

    private void getBsOK() {
        if (this.noValuesAtAll || this.nMolecules == 1) {
            return;
        }
        this.bsOK = BS.newN((int)(this.nX * this.nY * this.nZ));
        this.setXYZBohr(null);
        int index = 0;
        for (int ix = 0; ix < this.countsXYZ[0]; ++ix) {
            for (int iy = 0; iy < this.countsXYZ[1]; ++iy) {
                for (int iz = 0; iz < this.countsXYZ[2]; ++iz) {
                    this.processAtoms(ix, iy, iz, index);
                    ++index;
                }
            }
        }
        Logger.info((String)("NCI calculation SCF " + (this.type == 1 ? "intra" : "inter") + "molecular grid points = " + this.bsOK.cardinality()));
    }

    @Override
    public void createCube() {
        this.setXYZBohr(this.points);
        this.process();
    }

    @Override
    protected void initializeOnePoint() {
        if (this.eigen == null) {
            this.initializeEigen();
        }
        this.isReducedDensity = false;
        this.initializeOnePointQC();
    }

    private void initializeEigen() {
        this.eigen = new Eigen().set(3);
        this.hess = new double[3][3];
    }

    @Override
    public void getPlane(int ix, float[] yzPlane) {
        if (this.noValuesAtAll) {
            for (int j = 0; j < this.yzCount; ++j) {
                yzPlane[j] = Float.NaN;
            }
            return;
        }
        this.isReducedDensity = true;
        this.initialize(this.countsXYZ[0], this.countsXYZ[1], this.countsXYZ[2], null);
        this.setXYZBohr(null);
        int index = ix * this.yzCount;
        int i = 0;
        for (int iy = 0; iy < this.countsXYZ[1]; ++iy) {
            for (int iz = 0; iz < this.countsXYZ[2]; ++iz) {
                yzPlane[i] = this.bsOK == null || this.bsOK.get(index + i) ? this.getValue(this.processAtoms(ix, iy, iz, -1), this.isReducedDensity) : Float.NaN;
                ++i;
            }
        }
    }

    @Override
    protected void process() {
        if (this.noValuesAtAll) {
            return;
        }
        int ix = this.xMax;
        while (--ix >= this.xMin) {
            for (int iy = this.yMin; iy < this.yMax; ++iy) {
                float[] vd = this.voxelData[ix][this.havePoints ? 0 : iy];
                for (int iz = this.zMin; iz < this.zMax; ++iz) {
                    vd[this.havePoints ? 0 : iz] = this.getValue(this.processAtoms(ix, iy, iz, -1), this.isReducedDensity);
                }
            }
        }
    }

    private float getValue(double rho, boolean isReducedDensity) {
        double s;
        if (rho == 100.0) {
            return Float.NaN;
        }
        if (isReducedDensity) {
            s = c * this.grad * Math.pow(rho, rpower);
        } else if (this.useAbsolute) {
            s = rho;
        } else {
            this.hess[0][0] = this.gxxTemp;
            double d = this.gxyTemp;
            this.hess[0][1] = d;
            this.hess[1][0] = d;
            double d2 = this.gxzTemp;
            this.hess[0][2] = d2;
            this.hess[2][0] = d2;
            this.hess[1][1] = this.gyyTemp;
            double d3 = this.gyzTemp;
            this.hess[2][1] = d3;
            this.hess[1][2] = d3;
            this.hess[2][2] = this.gzzTemp;
            this.eigen.calc(this.hess);
            this.eigen.fillFloatArrays(null, this.eigenValues);
            s = this.eigenValues[1] < 0.0f ? -rho : rho;
        }
        return (float)s;
    }

    private double processAtoms(int ix, int iy, int iz, int index) {
        int i;
        double rho = 0.0;
        if (this.isReducedDensity) {
            if (this.isPromolecular) {
                this.gzTemp = 0.0;
                this.gyTemp = 0.0;
                this.gxTemp = 0.0;
            }
            if (this.type != 0) {
                i = this.nMolecules;
                while (--i >= 0) {
                    this.rhoMolecules[i] = 0.0;
                }
            }
        } else {
            this.gxzTemp = 0.0;
            this.gyzTemp = 0.0;
            this.gxyTemp = 0.0;
            this.gzzTemp = 0.0;
            this.gyyTemp = 0.0;
            this.gxxTemp = 0.0;
        }
        i = this.qmAtoms.length;
        while (--i >= 0) {
            double fac1r;
            double ce3;
            double ce2;
            int znuc = this.qmAtoms[i].znuc;
            double x = this.xBohr[ix] - this.qmAtoms[i].x;
            double y = this.yBohr[iy] - this.qmAtoms[i].y;
            double z = this.zBohr[iz] - this.qmAtoms[i].z;
            if (Math.abs(x) > dMax[znuc] || Math.abs(y) > dMax[znuc] || Math.abs(z) > dMax[znuc]) continue;
            double r = Math.sqrt(x * x + y * y + z * z);
            double z1 = zeta1[znuc];
            double z2 = zeta2[znuc];
            double z3 = zeta3[znuc];
            double ce1 = coef1[znuc] * Math.exp(-r / z1);
            double rhoAtom = ce1 + (ce2 = coef2[znuc] * Math.exp(-r / z2)) + (ce3 = coef3[znuc] * Math.exp(-r / z3));
            if ((rho += rhoAtom) > this.rhoPlot || rho < this.rhoMin) {
                return 100.0;
            }
            if (this.isReducedDensity) {
                if (this.type != 0) {
                    int n = this.qmAtoms[i].iMolecule;
                    this.rhoMolecules[n] = this.rhoMolecules[n] + rhoAtom;
                }
                if (!this.isPromolecular) continue;
                fac1r = (ce1 / z1 + ce2 / z2 + ce3 / z3) / r;
                this.gxTemp -= fac1r * x;
                this.gyTemp -= fac1r * y;
                this.gzTemp -= fac1r * z;
                continue;
            }
            fac1r = (ce1 / z1 + ce2 / z2 + ce3 / z3) / r;
            double fr2 = fac1r + (ce1 / z1 / z1 + ce2 / z2 / z2 + ce3 / z3 / z3);
            this.gxxTemp += fr2 * (x /= r) * x - fac1r;
            this.gyyTemp += fr2 * (y /= r) * y - fac1r;
            this.gzzTemp += fr2 * (z /= r) * z - fac1r;
            this.gxyTemp += fr2 * x * y;
            this.gxzTemp += fr2 * x * z;
            this.gyzTemp += fr2 * y * z;
        }
        if (this.isReducedDensity) {
            switch (this.type) {
                case 1: 
                case 2: {
                    boolean isIntra = false;
                    double rhocut2 = this.rhoParam * rho;
                    for (int i2 = 0; i2 < this.nMolecules; ++i2) {
                        if (!(this.rhoMolecules[i2] >= rhocut2)) continue;
                        isIntra = true;
                        break;
                    }
                    if (this.type == 1 != isIntra) {
                        return 100.0;
                    }
                    if (index < 0) break;
                    this.bsOK.set(index);
                    return 0.0;
                }
                case 3: {
                    break;
                }
            }
            this.grad = this.useAbsolute ? this.gxTemp + this.gyTemp + this.gzTemp : Math.sqrt(this.gxTemp * this.gxTemp + this.gyTemp * this.gyTemp + this.gzTemp * this.gzTemp);
        }
        return rho;
    }

    @Override
    public void setPlanes(float[][] planes) {
        this.yzPlanesRaw = planes;
        this.yzCount = this.nY * this.nZ;
    }

    @Override
    public void calcPlane(int x, float[] plane) {
        this.yzPlanesRho[0] = this.yzPlanesRho[1];
        this.yzPlanesRho[1] = plane;
        if (this.noValuesAtAll) {
            for (int j = 0; j < this.yzCount; ++j) {
                plane[j] = Float.NaN;
            }
            return;
        }
        int i0 = 0;
        if (this.dataIsReducedDensity) {
            this.p1 = plane;
        } else {
            int i;
            i0 = this.yzPlanesRho[0] == null ? 0 : 1;
            this.p0 = this.yzPlanesRaw[i0++];
            this.p1 = this.yzPlanesRaw[i0++];
            this.p2 = this.yzPlanesRaw[i0++];
            int n = i = i0 == 4 ? 3 : 0;
            while (i < i0) {
                for (int j = 0; j < this.yzCount; ++j) {
                    this.yzPlanesRaw[i][j] = Math.abs(this.yzPlanesRaw[i][j] * this.dataScaling);
                }
                ++i;
            }
        }
        int index = x * this.yzCount;
        int i = 0;
        for (int y = 0; y < this.nY; ++y) {
            int z = 0;
            while (z < this.nZ) {
                double rho = this.p1[i];
                if (this.bsOK != null && !this.bsOK.get(index + i)) {
                    plane[i] = Float.NaN;
                } else if (!this.dataIsReducedDensity) {
                    if (rho == 0.0) {
                        plane[i] = 0.0f;
                    } else if (rho > this.rhoPlot || rho < this.rhoMin || y == 0 || y == this.nY - 1 || z == 0 || z == this.nZ - 1) {
                        plane[i] = Float.NaN;
                    } else {
                        this.gxTemp = (this.p2[i] - this.p0[i]) / (2.0f * this.stepBohr[0]);
                        this.gyTemp = (this.p1[i + this.nZ] - this.p1[i - this.nZ]) / (2.0f * this.stepBohr[1]);
                        this.gzTemp = (this.p1[i + 1] - this.p1[i - 1]) / (2.0f * this.stepBohr[2]);
                        this.grad = Math.sqrt(this.gxTemp * this.gxTemp + this.gyTemp * this.gyTemp + this.gzTemp * this.gzTemp);
                        plane[i] = this.getValue(rho, true);
                    }
                }
                ++z;
                ++i;
            }
        }
    }

    @Override
    public float process(int vA, int vB, float f) {
        double valueA = this.getPlaneValue(vA);
        double valueB = this.getPlaneValue(vB);
        return (float)(valueA + (double)f * (valueB - valueA));
    }

    private double getPlaneValue(int vA) {
        int i = vA % this.yzCount;
        int x = vA / this.yzCount;
        int y = i / this.nZ;
        int z = i % this.nZ;
        if (x == 0 || x == this.nX - 1 || y == 0 || y == this.nY - 1 || z == 0 || z == this.nZ - 1) {
            return 100.0;
        }
        int iPlane = x % 2;
        float[] p0 = this.yzPlanesRaw[iPlane++];
        float[] p1 = this.yzPlanesRaw[iPlane++];
        float[] p2 = this.yzPlanesRaw[iPlane++];
        double rho = p1[i];
        if (rho > this.rhoPlot || rho < this.rhoMin) {
            return 100.0;
        }
        float dx = this.stepBohr[0];
        float dy = this.stepBohr[1];
        float dz = this.stepBohr[2];
        this.gxxTemp = ((double)p2[i] - 2.0 * rho + (double)p0[i]) / (double)(dx * dx);
        this.gyyTemp = ((double)p1[i + this.nZ] - 2.0 * rho + (double)p1[i - this.nZ]) / (double)(dy * dy);
        this.gzzTemp = ((double)p1[i + 1] - 2.0 * rho + (double)p1[i - 1]) / (double)(dz * dz);
        this.gxyTemp = (p2[i + this.nZ] - p2[i - this.nZ] - (p0[i + this.nZ] - p0[i - this.nZ])) / (4.0f * dx * dy);
        this.gxzTemp = (p2[i + 1] - p2[i - 1] - (p0[i + 1] - p0[i - 1])) / (4.0f * dx * dz);
        this.gyzTemp = (p1[i + this.nZ + 1] - p1[i - this.nZ + 1] - (p1[i + this.nZ - 1] - p1[i - this.nZ - 1])) / (4.0f * dy * dz);
        if (Double.isNaN(this.gxxTemp) || Double.isNaN(this.gyyTemp) || Double.isNaN(this.gzzTemp) || Double.isNaN(this.gxyTemp) || Double.isNaN(this.gxzTemp) || Double.isNaN(this.gyzTemp)) {
            return Double.NaN;
        }
        return this.getValue(rho, false);
    }
}

