/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import javajs.J2SIgnoreImport;
import javajs.api.GenericBinaryDocument;
import javajs.util.OC;
import javajs.util.PT;
import javajs.util.Rdr;
import org.jmol.api.Interface;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.SurfaceReader;
import org.jmol.viewer.Viewer;

@J2SIgnoreImport(value={Rdr.StreamReader.class})
abstract class SurfaceFileReader
extends SurfaceReader {
    protected BufferedReader br;
    protected GenericBinaryDocument binarydoc;
    protected OC out;
    protected String line;
    protected int[] next = new int[1];

    SurfaceFileReader() {
    }

    protected void setStream(String fileName, boolean isBigEndian) {
        if (fileName == null) {
            this.binarydoc.setStream(null, isBigEndian);
        } else {
            try {
                if (this.br instanceof Rdr.StreamReader) {
                    BufferedInputStream stream = ((Rdr.StreamReader)this.br).getStream();
                    stream.reset();
                    this.binarydoc.setStream(stream, true);
                }
            }
            catch (Exception e) {
                System.out.println("BCifDensityReader " + e);
                this.binarydoc.setStream(this.sg.atomDataServer.getBufferedInputStream(fileName), isBigEndian);
            }
        }
    }

    @Override
    void init(SurfaceGenerator sg) {
        this.initSR(sg);
    }

    void init2(SurfaceGenerator sg, BufferedReader br) {
        this.init2SFR(sg, br);
    }

    void init2SFR(SurfaceGenerator sg, BufferedReader br) {
        this.br = br;
        this.init(sg);
    }

    GenericBinaryDocument newBinaryDocument() {
        return (GenericBinaryDocument)Interface.getInterface((String)"javajs.util.BinaryDocument", (Viewer)((Viewer)this.sg.atomDataServer), (String)"file");
    }

    @Override
    protected void setOutputChannel(OC out) {
        if (this.binarydoc == null) {
            this.out = out;
        } else {
            this.sg.setOutputChannel(this.binarydoc, out);
        }
    }

    @Override
    protected void closeReader() {
        this.closeReaderSFR();
    }

    protected void closeReaderSFR() {
        if (this.br != null) {
            try {
                this.br.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.out != null) {
            this.out.closeChannel();
        }
        if (this.binarydoc != null) {
            this.binarydoc.close();
        }
    }

    @Override
    void discardTempData(boolean discardAll) {
        this.closeReader();
        this.discardTempDataSR(discardAll);
    }

    protected String[] getTokens() {
        return PT.getTokensAt((String)this.line, (int)0);
    }

    protected float parseFloat() {
        return PT.parseFloatNext((String)this.line, (int[])this.next);
    }

    protected float parseFloatStr(String s) {
        this.next[0] = 0;
        return PT.parseFloatNext((String)s, (int[])this.next);
    }

    protected float parseFloatRange(String s, int iStart, int iEnd) {
        this.next[0] = iStart;
        return PT.parseFloatRange((String)s, (int)iEnd, (int[])this.next);
    }

    protected int parseInt() {
        return PT.parseIntNext((String)this.line, (int[])this.next);
    }

    protected int parseIntStr(String s) {
        this.next[0] = 0;
        return PT.parseIntNext((String)s, (int[])this.next);
    }

    protected int parseIntNext(String s) {
        return PT.parseIntNext((String)s, (int[])this.next);
    }

    protected float[] parseFloatArrayStr(String s) {
        this.next[0] = 0;
        return PT.parseFloatArrayNext((String)s, (int[])this.next, null, null, null);
    }

    protected float[] parseFloatArray(float[] a, String strStart, String strEnd) {
        return PT.parseFloatArrayNext((String)this.line, (int[])this.next, (float[])a, (String)strStart, (String)strEnd);
    }

    protected String getQuotedStringNext() {
        return PT.getQuotedStringNext((String)this.line, (int[])this.next);
    }

    protected void skipTo(String info, String what) throws Exception {
        if (info != null) {
            while (this.rd().indexOf(info) < 0) {
            }
        }
        if (what != null) {
            this.next[0] = this.line.indexOf(what) + what.length() + 2;
        }
    }

    protected String rd() throws Exception {
        this.line = this.br.readLine();
        if (this.line != null) {
            this.nBytes += (long)this.line.length();
            if (this.out != null) {
                byte[] b = this.line.getBytes();
                this.out.write(b, 0, b.length);
                this.out.writeByteAsInt(10);
            }
        }
        return this.line;
    }
}

