/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.simple;

import javajs.util.P3;
import javajs.util.T3;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class AmpacReader
extends AtomSetCollectionReader {
    private int ac;
    private int freqAtom0 = -1;
    private float[] partialCharges;
    private P3[] atomPositions;

    protected boolean checkLine() throws Exception {
        if (this.line.indexOf("CARTESIAN COORDINATES") >= 0) {
            if (!this.doGetModel(++this.modelNumber, null)) {
                return this.checkLastModel();
            }
            this.readCoordinates();
            return true;
        }
        if (!this.doProcessLines) {
            return true;
        }
        if (this.line.indexOf("NET ATOMIC CHARGES") >= 0) {
            this.readPartialCharges();
            return true;
        }
        if (this.line.indexOf("VIBRATIONAL FREQUENCIES") >= 0) {
            this.readFrequencies();
            return true;
        }
        return true;
    }

    private void readCoordinates() throws Exception {
        String[] tokens;
        boolean haveFreq;
        boolean bl = haveFreq = this.freqAtom0 >= 0;
        if (haveFreq) {
            this.atomPositions = new P3[this.ac];
        } else {
            this.asc.newAtomSet();
        }
        this.rd();
        this.ac = 0;
        while (this.rd() != null && (tokens = this.getTokens()).length >= 5) {
            if (haveFreq) {
                this.atomPositions[this.ac] = P3.new3((float)this.parseFloatStr(tokens[2]), (float)this.parseFloatStr(tokens[3]), (float)this.parseFloatStr(tokens[4]));
            } else {
                this.addAtomXYZSymName(tokens, 2, tokens[1], null);
            }
            ++this.ac;
        }
        if (haveFreq) {
            this.setPositions();
        }
    }

    private void setPositions() {
        int maxAtom = this.asc.ac;
        Atom[] atoms = this.asc.atoms;
        for (int i = this.freqAtom0; i < maxAtom; ++i) {
            atoms[i].setT((T3)this.atomPositions[i % this.ac]);
            atoms[i].partialCharge = this.partialCharges[i % this.ac];
        }
    }

    private void readPartialCharges() throws Exception {
        String[] tokens;
        this.rd();
        this.partialCharges = new float[this.ac];
        for (int i = 0; i < this.ac && this.rd() != null && (tokens = this.getTokens()).length >= 4; ++i) {
            this.partialCharges[i] = this.parseFloatStr(tokens[2]);
        }
    }

    private void readFrequencies() throws Exception {
        while (this.rd() != null && this.line.indexOf("FREQ  :") < 0) {
        }
        while (this.line != null && this.line.indexOf("FREQ  :") >= 0) {
            String[] frequencies = this.getTokens();
            while (this.rd() != null && this.line.indexOf("IR I") < 0) {
            }
            int iAtom0 = this.asc.ac;
            if (this.vibrationNumber == 0) {
                this.freqAtom0 = iAtom0;
            }
            int frequencyCount = frequencies.length - 2;
            boolean[] ignore = new boolean[frequencyCount];
            for (int i = 0; i < frequencyCount; ++i) {
                boolean bl = ignore[i] = !this.doGetVibration(++this.vibrationNumber);
                if (ignore[i]) continue;
                this.asc.cloneLastAtomSet();
                this.asc.setAtomSetName(frequencies[i + 2] + " cm^-1");
                this.asc.setAtomSetModelProperty("Frequency", frequencies[i + 2] + " cm^-1");
                this.asc.setAtomSetModelProperty(".PATH", "Frequencies");
            }
            this.fillFrequencyData(iAtom0, this.ac, this.ac, ignore, false, 8, 9, null, 0, null);
            this.rd();
            this.rd();
        }
    }
}

