/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.webexport;

import javajs.util.PT;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.jmol.i18n.GT;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.webexport.JmolInstance;
import org.openscience.jmol.app.webexport.WebExport;
import org.openscience.jmol.app.webexport.WebPanel;

class ScriptButtons
extends WebPanel {
    ScriptButtons(Viewer viewer, JFileChooser jFileChooser, WebPanel[] webPanelArray, int n) {
        super(viewer, jFileChooser, webPanelArray, n);
        this.panelName = "script_btn";
        this.listLabel = GT.$("These names will be used for button labels");
    }

    @Override
    JPanel appletParamPanel() {
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(WebExport.getScriptButtonPercent(), 20, 100, 5);
        this.appletSizeSpinnerP = new JSpinner(spinnerNumberModel);
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel(GT.$("% of window for JSmol width:")));
        jPanel.add(this.appletSizeSpinnerP);
        return jPanel;
    }

    @Override
    String fixHtml(String string) {
        int n = ((SpinnerNumberModel)this.appletSizeSpinnerP.getModel()).getNumber().intValue();
        int n2 = 100;
        int n3 = this.getInstanceList().getModel().getSize();
        if (!this.allSelectedWidgets().isEmpty()) {
            n2 = 85;
        }
        string = PT.rep(string, "@WIDTHPERCENT@", "" + n);
        string = PT.rep(string, "@LEFTPERCENT@", "" + (100 - n));
        string = PT.rep(string, "@NBUTTONS@", "" + n3);
        string = PT.rep(string, "@HEIGHT@", "" + n2);
        string = PT.rep(string, "@BOTTOMPERCENT@", "" + (100 - n2));
        return string;
    }

    @Override
    String getAppletDefs(int n, String string, StringBuilder stringBuilder, JmolInstance jmolInstance) {
        String string2 = jmolInstance.name;
        String string3 = jmolInstance.javaname;
        String string4 = "";
        int n2 = 0;
        if (!jmolInstance.whichWidgets.isEmpty()) {
            if (jmolInstance.whichWidgets.get(3)) {
                string4 = String.valueOf(string4) + "<div class=\"widgetItemAnim\"> " + this.theWidgets.widgetList[3].getJavaScript(0, jmolInstance) + "</div>";
            }
            string4 = String.valueOf(string4) + "<table><tbody><tr>";
            int n3 = 0;
            while (n3 < this.nWidgets) {
                if (n3 != 3 && jmolInstance.whichWidgets.get(n3)) {
                    if (n2 == 3) {
                        string4 = String.valueOf(string4) + "</tr><tr>";
                        n2 = 0;
                    }
                    string4 = String.valueOf(string4) + "<td class=\"widgetItemScBtn\">" + this.theWidgets.widgetList[n3].getJavaScript(0, jmolInstance) + "</td>";
                    ++n2;
                }
                ++n3;
            }
            string4 = String.valueOf(string4) + "</tr></tbody></table>";
        }
        if (n == 0) {
            string = PT.rep(string, "@APPLETNAME0@", GT.escapeHTML(string3));
        }
        String string5 = this.htmlAppletTemplate;
        string5 = PT.rep(string5, "@APPLETNAME0@", GT.escapeHTML(string3));
        string5 = PT.rep(string5, "@NAME@", "&#x201C;" + GT.escapeHTML(string2) + "&#x201D;");
        string5 = PT.rep(string5, "@LABEL@", GT.escapeHTML(string2));
        string5 = PT.rep(string5, "@I@", "" + n);
        string5 = PT.rep(string5, "@WIDGETSTR@", string4);
        stringBuilder.append(string5);
        return string;
    }
}

