/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import javajs.util.P3;
import javajs.util.P3i;
import org.jmol.c.STR;

public class TempArray {
    private static final int freePointsSize = 6;
    private final int[] lengthsFreePoints = new int[6];
    private final P3[][] freePoints = new P3[6][];
    private static final int freeScreensSize = 6;
    private final int[] lengthsFreeScreens = new int[6];
    private final P3i[][] freeScreens = new P3i[6][];
    private static final int freeEnumSize = 2;
    private final int[] lengthsFreeEnum = new int[2];
    private final STR[][] freeEnum = new STR[2][];

    public void clear() {
        this.clearTempPoints();
        this.clearTempScreens();
    }

    private static int findBestFit(int n, int[] nArray) {
        int n2 = -1;
        int n3 = Integer.MAX_VALUE;
        int n4 = nArray.length;
        while (--n4 >= 0) {
            int n5 = nArray[n4];
            if (n5 < n || n5 >= n3) continue;
            n3 = n5;
            n2 = n4;
        }
        if (n2 >= 0) {
            nArray[n2] = 0;
        }
        return n2;
    }

    private static int findShorter(int n, int[] nArray) {
        int n2 = nArray.length;
        while (--n2 >= 0) {
            if (nArray[n2] != 0) continue;
            nArray[n2] = n;
            return n2;
        }
        n2 = 0;
        int n3 = nArray[0];
        int n4 = nArray.length;
        while (--n4 > 0) {
            if (nArray[n4] >= n3) continue;
            n3 = nArray[n4];
            n2 = n4;
        }
        if (n3 < n) {
            nArray[n2] = n;
            return n2;
        }
        return -1;
    }

    private void clearTempPoints() {
        int n = 0;
        while (n < 6) {
            this.lengthsFreePoints[n] = 0;
            this.freePoints[n] = null;
            ++n;
        }
    }

    public P3[] allocTempPoints(int n) {
        P3[] p3Array;
        int n2 = TempArray.findBestFit(n, this.lengthsFreePoints);
        if (n2 > 0) {
            p3Array = this.freePoints[n2];
        } else {
            p3Array = new P3[n];
            int n3 = n;
            while (--n3 >= 0) {
                p3Array[n3] = new P3();
            }
        }
        return p3Array;
    }

    public void freeTempPoints(P3[] p3Array) {
        int n = 0;
        while (n < this.freePoints.length) {
            if (this.freePoints[n] == p3Array) {
                this.lengthsFreePoints[n] = p3Array.length;
                return;
            }
            ++n;
        }
        n = TempArray.findShorter(p3Array.length, this.lengthsFreePoints);
        if (n >= 0) {
            this.freePoints[n] = p3Array;
        }
    }

    private void clearTempScreens() {
        int n = 0;
        while (n < 6) {
            this.lengthsFreeScreens[n] = 0;
            this.freeScreens[n] = null;
            ++n;
        }
    }

    public P3i[] allocTempScreens(int n) {
        P3i[] p3iArray;
        int n2 = TempArray.findBestFit(n, this.lengthsFreeScreens);
        if (n2 > 0) {
            p3iArray = this.freeScreens[n2];
        } else {
            p3iArray = new P3i[n];
            int n3 = n;
            while (--n3 >= 0) {
                p3iArray[n3] = new P3i();
            }
        }
        return p3iArray;
    }

    public void freeTempScreens(P3i[] p3iArray) {
        int n = 0;
        while (n < this.freeScreens.length) {
            if (this.freeScreens[n] == p3iArray) {
                this.lengthsFreeScreens[n] = p3iArray.length;
                return;
            }
            ++n;
        }
        n = TempArray.findShorter(p3iArray.length, this.lengthsFreeScreens);
        if (n >= 0) {
            this.freeScreens[n] = p3iArray;
        }
    }

    public STR[] allocTempEnum(int n) {
        int n2 = TempArray.findBestFit(n, this.lengthsFreeEnum);
        STR[] sTRArray = n2 > 0 ? this.freeEnum[n2] : new STR[n];
        return sTRArray;
    }

    public void freeTempEnum(STR[] sTRArray) {
        int n = 0;
        while (n < this.freeEnum.length) {
            if (this.freeEnum[n] == sTRArray) {
                this.lengthsFreeEnum[n] = sTRArray.length;
                return;
            }
            ++n;
        }
        n = TempArray.findShorter(sTRArray.length, this.lengthsFreeEnum);
        if (n >= 0) {
            this.freeEnum[n] = sTRArray;
        }
    }

    public static Object[] getSlabWithinRange(float f, float f2) {
        Object[] objectArray = new Object[4];
        objectArray[0] = 1073742114;
        objectArray[1] = new Float[]{Float.valueOf(f), Float.valueOf(f2)};
        objectArray[2] = Boolean.FALSE;
        return objectArray;
    }

    public static Object[] getSlabObjectType(int n, Object object, boolean bl, Object object2) {
        return new Object[]{n, object, bl, object2};
    }
}

