/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.OC;
import javajs.util.SB;
import org.jmol.api.Interface;
import org.jmol.c.STR;
import org.jmol.dssx.DSSP;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Group;
import org.jmol.modelset.HBond;
import org.jmol.modelset.LabelToken;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.modelsetbio.AlphaPolymer;
import org.jmol.modelsetbio.AminoPolymer;
import org.jmol.modelsetbio.BioModelSet;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.script.SV;
import org.jmol.util.Escape;
import org.jmol.viewer.Viewer;

public final class BioModel
extends Model {
    private Viewer vwr;
    int bioPolymerCount = 0;
    public BioPolymer[] bioPolymers;
    boolean isMutated;
    String defaultStructure;

    BioModel(ModelSet modelSet, int n, int n2, String string, Properties properties, Map<String, Object> map) {
        this.vwr = modelSet.vwr;
        this.set(modelSet, n, n2, string, properties, map);
        this.isBioModel = true;
        if (modelSet.bioModelset == null) {
            modelSet.bioModelset = new BioModelSet().set(this.vwr, this.ms);
        }
        this.clearBioPolymers();
        modelSet.am[n] = this;
        this.pdbID = (String)map.get("name");
    }

    int addBioPolymer(BioPolymer bioPolymer) {
        if (this.bioPolymers.length == 0) {
            this.clearBioPolymers();
        }
        if (this.bioPolymerCount == this.bioPolymers.length) {
            this.bioPolymers = (BioPolymer[])AU.doubleLength(this.bioPolymers);
        }
        bioPolymer.bioPolymerIndexInModel = this.bioPolymerCount;
        this.bioPolymers[this.bioPolymerCount++] = bioPolymer;
        return bioPolymer.monomerCount;
    }

    void addSecondaryStructure(STR sTR, String string, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, BS bS) {
        int n9 = this.bioPolymerCount;
        while (--n9 >= 0) {
            if (!(this.bioPolymers[n9] instanceof AlphaPolymer)) continue;
            ((AlphaPolymer)this.bioPolymers[n9]).addStructure(sTR, string, n, n2, n3, n4, n5, n6, n7, n8, bS);
        }
    }

    void addStructureByBS(int n, int n2, STR sTR, BS bS) {
        int n3 = this.bioPolymerCount;
        while (--n3 >= 0) {
            BioPolymer bioPolymer = this.bioPolymers[n3];
            if (!(bioPolymer instanceof AlphaPolymer)) continue;
            ++n;
            n = ((AlphaPolymer)this.bioPolymers[n3]).setStructureBS(n, n2, sTR, bS, true);
        }
    }

    private String calculateDssx(Lst<Bond> lst, boolean bl, boolean bl2, boolean bl3, int n) {
        boolean bl4 = false;
        boolean bl5 = false;
        int n2 = 0;
        while (!(n2 >= this.bioPolymerCount || bl4 && bl5)) {
            if (this.bioPolymers[n2].isNucleic()) {
                bl5 = true;
            } else if (this.bioPolymers[n2] instanceof AminoPolymer) {
                bl4 = true;
            }
            ++n2;
        }
        String string = "";
        if (bl4) {
            string = String.valueOf(string) + ((DSSP)Interface.getOption("dssx.DSSP", this.vwr, "ms")).calculateDssp(this.bioPolymers, this.bioPolymerCount, lst, bl, bl2, bl3, n);
        }
        if (bl5 && this.auxiliaryInfo.containsKey("dssr") && lst != null) {
            string = String.valueOf(string) + this.vwr.getAnnotationParser(true).getHBonds(this.ms, this.modelIndex, lst, bl);
        }
        return string;
    }

    String calculateStructures(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n) {
        int n2;
        if (this.bioPolymerCount == 0 || !bl4 && !bl) {
            return "";
        }
        this.structureTainted = true;
        this.ms.proteinStructureTainted = true;
        if (bl4) {
            n2 = this.bioPolymerCount;
            while (--n2 >= 0) {
                if (bl && this.bioPolymers[n2].monomers[0].getNitrogenAtom() == null) continue;
                this.bioPolymers[n2].clearStructures();
            }
        }
        if (!bl || bl5) {
            n2 = this.bioPolymerCount;
            while (--n2 >= 0) {
                if (!(this.bioPolymers[n2] instanceof AlphaPolymer)) continue;
                ((AlphaPolymer)this.bioPolymers[n2]).calculateStructures(bl5);
            }
        }
        return bl ? this.calculateDssx(null, bl2, bl3, bl4, n) : "";
    }

    void clearBioPolymers() {
        this.bioPolymers = new BioPolymer[8];
        this.bioPolymerCount = 0;
    }

    @Override
    public void fixIndices(int n, int n2, BS bS) {
        this.fixIndicesM(n, n2, bS);
        this.recalculateLeadMidpointsAndWingVectors();
    }

    @Override
    public boolean freeze() {
        this.freezeM();
        this.bioPolymers = (BioPolymer[])AU.arrayCopyObject(this.bioPolymers, this.bioPolymerCount);
        return true;
    }

    public Lst<BS> getBioBranches(Lst<BS> lst) {
        int n = 0;
        while (n < this.bioPolymerCount) {
            BS bS = new BS();
            this.bioPolymers[n].getRange(bS, this.isMutated);
            int n2 = bS.nextSetBit(0);
            if (n2 >= 0) {
                if (lst == null) {
                    lst = new Lst();
                }
                lst.addLast(bS);
            }
            ++n;
        }
        return lst;
    }

    public int getBioPolymerCount() {
        return this.bioPolymerCount;
    }

    Object getCachedAnnotationMap(String string, Object map) {
        Hashtable hashtable;
        Hashtable hashtable2 = hashtable = this.dssrCache == null && map != null ? (this.dssrCache = new Hashtable()) : this.dssrCache;
        if (hashtable == null) {
            return null;
        }
        Object object = hashtable.get(string);
        if (object == null && map != null) {
            object = map instanceof SV || map instanceof Hashtable ? map : this.vwr.parseJSONMap((String)((Object)map));
            hashtable.put(string, object);
        }
        return object instanceof SV || object instanceof Hashtable ? object : null;
    }

    public boolean getConformation(int n, boolean bl, BS bS, BS bS2) {
        int n2;
        if (n >= 0 && (n2 = this.altLocCount) > 0) {
            Atom[] atomArray = this.ms.at;
            Group group = null;
            char c = '\u0000';
            int n3 = n;
            BS bS3 = new BS();
            int n4 = bS.nextSetBit(0);
            while (n4 >= 0) {
                Atom atom = atomArray[n4];
                char c2 = atom.altloc;
                if (c2 != '\u0000') {
                    if (atom.group != group) {
                        group = atom.group;
                        c = '\u0000';
                        n3 = n;
                        bS3.clearAll();
                    }
                    if (n3 >= 0 && c2 != c && !bS3.get(c2)) {
                        c = c2;
                        --n3;
                        bS3.set(c2);
                    }
                    if (n3 >= 0 || c2 != c) {
                        bS.clear(n4);
                    }
                }
                n4 = bS.nextSetBit(n4 + 1);
            }
        }
        if (bS.nextSetBit(0) >= 0) {
            bS2.or(bS);
            if (bl) {
                n2 = this.bioPolymerCount;
                while (--n2 >= 0) {
                    this.bioPolymers[n2].setConformation(bS);
                }
            }
        }
        return true;
    }

    public void getDefaultLargePDBRendering(SB sB, int n) {
        BS bS = new BS();
        if (this.getBondCount() == 0) {
            bS = this.bsAtoms;
        }
        if (bS != this.bsAtoms) {
            int n2 = 0;
            while (n2 < this.bioPolymerCount) {
                this.bioPolymers[n2].getRange(bS, this.isMutated);
                ++n2;
            }
        }
        if (bS.nextSetBit(0) < 0) {
            return;
        }
        BS bS2 = new BS();
        if (bS == this.bsAtoms) {
            bS2 = bS;
        } else {
            int n3 = 0;
            while (n3 < this.bioPolymerCount) {
                if (this.bioPolymers[n3].getType() == 0) {
                    this.bioPolymers[n3].getRange(bS2, this.isMutated);
                }
                ++n3;
            }
        }
        if (bS2.nextSetBit(0) >= 0) {
            sB.append("select ").append(Escape.eBS(bS2)).append(";backbone only;");
        }
        if (this.act <= n) {
            return;
        }
        sB.append("select ").append(Escape.eBS(bS)).append(" & connected; wireframe only;");
        if (bS != this.bsAtoms) {
            bS2.clearAll();
            bS2.or(this.bsAtoms);
            bS2.andNot(bS);
            if (bS2.nextSetBit(0) >= 0) {
                sB.append("select " + Escape.eBS(bS2) + " & !connected;stars 0.5;spacefill off;");
            }
        }
    }

    public String getFullPDBHeader() {
        if (this.modelIndex < 0) {
            return "";
        }
        String string = (String)this.auxiliaryInfo.get("fileHeader");
        if (string != null) {
            return string;
        }
        return this.ms.bioModelset.getBioExt().getFullPDBHeader(this.auxiliaryInfo);
    }

    public void getPdbData(String string, char c, boolean bl, BS bS, OC oC, LabelToken[] labelTokenArray, SB sB, BS bS2) {
        this.ms.bioModelset.getBioExt().getPdbDataM(this, this.vwr, string, c, bl, bS, oC, labelTokenArray, sB, bS2);
    }

    void getRasmolHydrogenBonds(BS bS, BS bS2, Lst<Bond> lst, boolean bl, int n, boolean bl2, BS bS3, int n2) {
        int n3;
        boolean bl3;
        boolean bl4;
        boolean bl5 = bl4 = lst == null;
        if (bl4) {
            lst = new Lst();
        }
        if (n < 0) {
            n = Integer.MAX_VALUE;
        }
        boolean bl6 = bl3 = bS2 == null;
        if (bl3 && this.bioPolymerCount > 0) {
            this.calculateDssx(lst, false, bl2, false, n2);
        } else {
            n3 = this.bioPolymerCount;
            block4: while (--n3 >= 0) {
                BioPolymer bioPolymer = this.bioPolymers[n3];
                if (bioPolymer.monomerCount == 0) continue;
                int n4 = bioPolymer.getType();
                boolean bl7 = false;
                switch (n4) {
                    case 1: {
                        if (bl) continue block4;
                        bioPolymer.calcRasmolHydrogenBonds(null, bS, bS2, lst, n, null, true, false);
                        break;
                    }
                    case 2: {
                        bl7 = bioPolymer.monomers[0].isRna();
                        break;
                    }
                    default: {
                        continue block4;
                    }
                }
                int n5 = this.bioPolymerCount;
                while (--n5 >= 0) {
                    BioPolymer bioPolymer2 = this.bioPolymers[n5];
                    if (bioPolymer2 == null || !bl7 && n3 == n5 || n4 != bioPolymer2.getType()) continue;
                    bioPolymer2.calcRasmolHydrogenBonds(bioPolymer, bS, bS2, lst, n, null, true, false);
                }
            }
        }
        if (lst.size() == 0 || !bl4) {
            return;
        }
        this.hasRasmolHBonds = true;
        n3 = 0;
        while (n3 < lst.size()) {
            HBond hBond = (HBond)lst.get(n3);
            Atom atom = hBond.atom1;
            Atom atom2 = hBond.atom2;
            if (!atom.isBonded(atom2)) {
                int n6 = this.ms.addHBond(atom, atom2, hBond.order, hBond.getEnergy());
                if (bS3 != null) {
                    bS3.set(n6);
                }
            }
            ++n3;
        }
    }

    public String getUnitID(Atom atom, int n) {
        boolean bl;
        SB sB = new SB();
        Group group = atom.group;
        boolean bl2 = (n & 0x10) != 16;
        char c = (n & 8) == 8 ? group.getInsertionCode() : (char)'\u0000';
        boolean bl3 = bl = c != '\u0000';
        if ((n & 1) == 1 && this.pdbID != null) {
            sB.append(this.pdbID);
        }
        sB.append("|").appendO(this.ms.getInfo(this.modelIndex, "modelNumber")).append("|").append(this.vwr.getChainIDStr(group.chain.chainID)).append("|").append(group.getGroup3()).append("|").appendI(group.getResno());
        if ((n & 4) == 4) {
            sB.append("|").append(atom.getAtomName());
            if (atom.altloc != '\u0000') {
                sB.append("|").appendC(atom.altloc);
            } else if (bl2 || bl) {
                sB.append("|");
            }
        } else if (bl2 || bl) {
            sB.append("||");
        }
        if (bl) {
            sB.append("|").appendC(c);
        } else if (bl2) {
            sB.append("|");
        }
        if (bl2) {
            sB.append("|");
        }
        return sB.toString();
    }

    void recalculateLeadMidpointsAndWingVectors() {
        int n = 0;
        while (n < this.bioPolymerCount) {
            this.bioPolymers[n].recalculateLeadMidpointsAndWingVectors();
            ++n;
        }
    }

    public void resetRasmolBonds(BS bS, int n) {
        BS bS2 = new BS();
        this.hasRasmolHBonds = false;
        Model[] modelArray = this.ms.am;
        Bond[] bondArray = this.ms.bo;
        int n2 = this.ms.bondCount;
        while (--n2 >= 0) {
            Bond bond = bondArray[n2];
            if ((bond.order & 0x7000) == 0 || modelArray[bond.atom1.mi].trajectoryBaseIndex != this.modelIndex) continue;
            bS2.set(n2);
        }
        if (bS2.nextSetBit(0) >= 0) {
            this.ms.deleteBonds(bS2, false);
        }
        this.getRasmolHydrogenBonds(bS, bS, null, false, Integer.MAX_VALUE, false, null, n);
    }

    public void getAtomicDSSRData(float[] fArray, String string) {
        if (this.auxiliaryInfo.containsKey("dssr")) {
            this.vwr.getAnnotationParser(true).getAtomicDSSRData(this.ms, this.modelIndex, fArray, string);
        }
    }
}

