/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeFileReader;

class ApbsReader
extends VolumeFileReader {
    ApbsReader() {
    }

    @Override
    void init2(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        this.init2VFR(surfaceGenerator, bufferedReader);
        if (this.params.thePlane == null) {
            this.params.insideOut = !this.params.insideOut;
        }
        this.isAngstroms = true;
        this.nSurfaces = 1;
    }

    @Override
    protected void readParameters() throws Exception {
        this.jvxlFileHeaderBuffer = SB.newS(this.skipComments(false));
        while (this.line != null && this.line.length() == 0) {
            this.rd();
        }
        this.jvxlFileHeaderBuffer.append("APBS OpenDx DATA ").append(this.line).append("\n");
        this.jvxlFileHeaderBuffer.append("see http://apbs.sourceforge.net\n");
        String string = this.rd();
        String[] stringArray = PT.getTokens(string);
        if (stringArray.length >= 4) {
            this.volumetricOrigin.set(this.parseFloatStr(stringArray[1]), this.parseFloatStr(stringArray[2]), this.parseFloatStr(stringArray[3]));
        }
        VolumeFileReader.checkAtomLine(this.isXLowToHigh, this.isAngstroms, stringArray[0], string, this.jvxlFileHeaderBuffer);
        this.readVoxelVector(0);
        this.readVoxelVector(1);
        this.readVoxelVector(2);
        this.rd();
        stringArray = this.getTokens();
        int n = 0;
        while (n < 3) {
            this.voxelCounts[n] = this.parseIntStr(stringArray[n + 5]);
            ++n;
        }
        this.rd();
    }
}

