/*
 * Decompiled with CFR 0.152.
 */
package jspecview.export;

import java.io.IOException;
import java.util.Hashtable;
import javajs.api.GenericColor;
import javajs.util.CU;
import javajs.util.DF;
import javajs.util.Lst;
import javajs.util.OC;
import jspecview.common.ColorParameters;
import jspecview.common.Coordinate;
import jspecview.common.ExportType;
import jspecview.common.JSViewer;
import jspecview.common.PanelData;
import jspecview.common.ScaleData;
import jspecview.common.ScriptToken;
import jspecview.common.Spectrum;
import jspecview.export.FormExporter;
import org.jmol.util.Logger;

public class SVGExporter
extends FormExporter {
    private static int svgWidth = 850;
    private static int svgHeight = 400;
    private static int leftInset = 100;
    private static int rightInset = 200;
    private static int bottomInset = 80;
    private static int topInset = 20;

    @Override
    public String exportTheSpectrum(JSViewer jSViewer, ExportType exportType, OC oC, Spectrum spectrum, int n, int n2, PanelData panelData, boolean bl) throws IOException {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        Hashtable<String, String> hashtable;
        Cloneable cloneable;
        String string;
        String string2;
        double d6;
        double d7;
        GenericColor genericColor;
        GenericColor genericColor2;
        GenericColor genericColor3;
        GenericColor genericColor4;
        GenericColor genericColor5;
        GenericColor genericColor6;
        GenericColor genericColor7;
        this.initForm(jSViewer, oC);
        if (panelData == null) {
            genericColor6 = genericColor7 = ColorParameters.BLACK;
            genericColor5 = genericColor7;
            genericColor4 = genericColor7;
            genericColor3 = genericColor7;
            genericColor2 = genericColor7;
            genericColor = genericColor7;
        } else {
            genericColor = panelData.getColor(ScriptToken.PLOTAREACOLOR);
            genericColor2 = panelData.bgcolor;
            genericColor3 = panelData.getCurrentPlotColor(0);
            genericColor4 = panelData.getColor(ScriptToken.GRIDCOLOR);
            genericColor5 = panelData.getColor(ScriptToken.TITLECOLOR);
            genericColor6 = panelData.getColor(ScriptToken.SCALECOLOR);
            genericColor7 = panelData.getColor(ScriptToken.UNITSCOLOR);
        }
        Coordinate[] coordinateArray = spectrum.getXYCoords();
        ScaleData scaleData = new ScaleData(coordinateArray, n, n2, spectrum.isContinuous(), spectrum.isInverted());
        double d8 = scaleData.maxXOnScale;
        double d9 = scaleData.minXOnScale;
        double d10 = scaleData.maxYOnScale;
        double d11 = scaleData.minYOnScale;
        double d12 = scaleData.steps[0];
        double d13 = scaleData.steps[1];
        int n3 = svgWidth - leftInset - rightInset;
        int n4 = svgHeight - topInset - bottomInset;
        double d14 = (double)n3 / (d8 - d9);
        double d15 = (double)n4 / (d10 - d11);
        int n5 = leftInset;
        int n6 = leftInset + n3;
        int n7 = topInset;
        int n8 = topInset + n4;
        int n9 = n8 + 60;
        this.context.put("titlePosition", new Integer(n9));
        Lst<Cloneable> lst = new Lst<Cloneable>();
        Lst<Cloneable> lst2 = new Lst<Cloneable>();
        double d16 = d9;
        while (d16 < d8 + d12 / 2.0) {
            d7 = (double)n5 + (d16 - d9) * d14;
            d6 = n7;
            string2 = DF.formatDecimalTrimmed(d7, 6);
            string = DF.formatDecimalTrimmed(d6, 6);
            cloneable = new Hashtable();
            cloneable.put("xVal", string2);
            cloneable.put("yVal", string);
            lst.addLast(cloneable);
            d16 += d12;
        }
        d16 = d11;
        while (d16 < d10 + d13 / 2.0) {
            d7 = n5;
            d6 = (double)n7 + (d16 - d11) * d15;
            string2 = DF.formatDecimalTrimmed(d7, 6);
            string = DF.formatDecimalTrimmed(d6, 6);
            cloneable = new Hashtable();
            cloneable.put("xVal", string2);
            cloneable.put("yVal", string);
            lst2.addLast(cloneable);
            d16 += d13;
        }
        Lst lst3 = new Lst();
        Lst lst4 = new Lst();
        cloneable = new Lst();
        int n10 = scaleData.precision[0];
        int n11 = scaleData.precision[1];
        double d17 = d9;
        while (d17 < d8 + d12 / 2.0) {
            d7 = (double)n5 + (d17 - d9) * d14;
            d6 = n8 + 15;
            string2 = DF.formatDecimalTrimmed(d7 -= 10.0, 6);
            string = DF.formatDecimalTrimmed(d6, 6);
            String string3 = DF.formatDecimalDbl(d17, n10);
            hashtable = new Hashtable<String, String>();
            hashtable.put("xVal", string2);
            hashtable.put("yVal", string);
            hashtable.put("number", string3);
            lst3.addLast(hashtable);
            d17 += d12;
        }
        d17 = d9;
        double d18 = d8;
        while (d17 < d8 + d12 / 2.0) {
            d7 = (double)n5 + (d18 - d9) * d14;
            d6 = n8 + 15;
            string2 = DF.formatDecimalTrimmed(d7 -= 10.0, 6);
            string = DF.formatDecimalTrimmed(d6, 6);
            String string4 = DF.formatDecimalDbl(d17, n10);
            Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
            hashtable2.put("xVal", string2);
            hashtable2.put("yVal", string);
            hashtable2.put("number", string4);
            lst4.addLast(hashtable2);
            d17 += d12;
            d18 -= d12;
        }
        d17 = d11;
        while (d17 < d10 + d13 / 2.0) {
            d7 = n5 - 55;
            d6 = (double)n8 - (d17 - d11) * d15;
            string2 = DF.formatDecimalTrimmed(d7, 6);
            string = DF.formatDecimalTrimmed(d6 += 3.0, 6);
            String string5 = DF.formatDecimalDbl(d17, n11);
            hashtable = new Hashtable();
            hashtable.put("xVal", string2);
            hashtable.put("yVal", string);
            hashtable.put("number", string5);
            ((Lst)cloneable).addLast(hashtable);
            d17 += d13;
        }
        boolean bl2 = spectrum.isXIncreasing();
        if (bl2) {
            d17 = n5;
            d5 = n8;
            d4 = d14;
            d3 = -d15;
            d2 = -1.0 * d9;
            d = -1.0 * d11;
        } else {
            d17 = n6;
            d5 = n8;
            d4 = -d14;
            d3 = -d15;
            d2 = -d9;
            d = -d11;
        }
        double d19 = d11 - d13 / 2.0;
        double d20 = d13 / 5.0;
        this.context.put("plotAreaColor", CU.toRGBHexString(genericColor));
        this.context.put("backgroundColor", CU.toRGBHexString(genericColor2));
        this.context.put("plotColor", CU.toRGBHexString(genericColor3));
        this.context.put("gridColor", CU.toRGBHexString(genericColor4));
        this.context.put("titleColor", CU.toRGBHexString(genericColor5));
        this.context.put("scaleColor", CU.toRGBHexString(genericColor6));
        this.context.put("unitsColor", CU.toRGBHexString(genericColor7));
        this.context.put("svgHeight", new Integer(svgHeight));
        this.context.put("svgWidth", new Integer(svgWidth));
        this.context.put("leftPlotArea", new Integer(n5));
        this.context.put("rightPlotArea", new Integer(n6));
        this.context.put("topPlotArea", new Integer(n7));
        this.context.put("bottomPlotArea", new Integer(n8));
        this.context.put("plotAreaHeight", new Integer(n4));
        this.context.put("plotAreaWidth", new Integer(n3));
        this.context.put("minXOnScale", new Double(d9));
        this.context.put("maxXOnScale", new Double(d8));
        this.context.put("minYOnScale", new Double(d11));
        this.context.put("maxYOnScale", new Double(d10));
        this.context.put("yTickA", new Double(d19));
        this.context.put("yTickB", new Double(d20));
        this.context.put("xScaleFactor", new Double(d14));
        this.context.put("yScaleFactor", new Double(d15));
        this.context.put("increasing", new Boolean(bl2));
        this.context.put("verticalGridCoords", lst);
        this.context.put("horizontalGridCoords", lst2);
        Lst<Coordinate> lst5 = new Lst<Coordinate>();
        int n12 = n;
        while (n12 <= n2) {
            lst5.addLast(coordinateArray[n12]);
            ++n12;
        }
        double d21 = coordinateArray[n].getXVal();
        double d22 = coordinateArray[n].getYVal();
        double d23 = coordinateArray[n2].getXVal();
        this.context.put("title", genericColor5);
        this.context.put("xyCoords", lst5);
        this.context.put("continuous", new Boolean(spectrum.isContinuous()));
        this.context.put("firstTranslateX", new Double(d17));
        this.context.put("firstTranslateY", new Double(d5));
        this.context.put("scaleX", new Double(d4));
        this.context.put("scaleY", new Double(d3));
        this.context.put("secondTranslateX", new Double(d2));
        this.context.put("secondTranslateY", new Double(d));
        if (bl2) {
            this.context.put("xScaleList", lst3);
            this.context.put("xScaleListReversed", lst4);
        } else {
            this.context.put("xScaleList", lst4);
            this.context.put("xScaleListReversed", lst3);
        }
        this.context.put("yScaleList", cloneable);
        this.context.put("xUnits", spectrum.getXUnits());
        this.context.put("yUnits", spectrum.getYUnits());
        this.context.put("firstX", d21);
        this.context.put("firstY", d22);
        this.context.put("lastX", d23);
        int n13 = n6 - 50;
        int n14 = n8 + 30;
        int n15 = n5 - 80;
        int n16 = n8 / 2;
        int n17 = n15;
        n15 = -n16;
        n16 = n17;
        this.context.put("xUnitLabelX", "" + n13);
        this.context.put("xUnitLabelY", "" + n14);
        this.context.put("yUnitLabelX", "" + n15);
        this.context.put("yUnitLabelY", "" + n16);
        this.context.put("numDecimalPlacesX", new Integer(Math.abs(scaleData.exportPrecision[0])));
        this.context.put("numDecimalPlacesY", new Integer(Math.abs(scaleData.exportPrecision[1])));
        String string6 = exportType == ExportType.SVGI ? "plot_ink.vm" : "plot.vm";
        Logger.info("SVGExporter using " + string6);
        return this.writeForm(string6);
    }
}

