/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.Hashtable;
import java.util.Map;
import javajs.J2SRequireImport;
import javajs.util.AU;
import javajs.util.V3;

@J2SRequireImport(value={AU.class})
public class Geodesic {
    private static final float halfRoot5 = (float)(0.5 * Math.sqrt(5.0));
    private static final float oneFifth = 1.2566371f;
    private static final float oneTenth = 0.62831855f;
    private static final short[] faceVertexesIcosahedron;
    private static final short[] neighborVertexesIcosahedron;
    public static final int standardLevel = 3;
    private static final int maxLevel = 3;
    private static short[] vertexCounts;
    private static V3[] vertexVectors;
    private static short[][] faceVertexesArrays;
    private static short[][] neighborVertexesArrays;
    private static int currentLevel;
    private static short vertexNext;
    private static Map<Integer, Short> htVertex;
    private static final boolean VALIDATE = true;

    static {
        short[] sArray = new short[60];
        sArray[1] = 1;
        sArray[2] = 2;
        sArray[4] = 2;
        sArray[5] = 3;
        sArray[7] = 3;
        sArray[8] = 4;
        sArray[10] = 4;
        sArray[11] = 5;
        sArray[13] = 5;
        sArray[14] = 1;
        sArray[15] = 1;
        sArray[16] = 6;
        sArray[17] = 2;
        sArray[18] = 2;
        sArray[19] = 7;
        sArray[20] = 3;
        sArray[21] = 3;
        sArray[22] = 8;
        sArray[23] = 4;
        sArray[24] = 4;
        sArray[25] = 9;
        sArray[26] = 5;
        sArray[27] = 5;
        sArray[28] = 10;
        sArray[29] = 1;
        sArray[30] = 6;
        sArray[31] = 1;
        sArray[32] = 10;
        sArray[33] = 7;
        sArray[34] = 2;
        sArray[35] = 6;
        sArray[36] = 8;
        sArray[37] = 3;
        sArray[38] = 7;
        sArray[39] = 9;
        sArray[40] = 4;
        sArray[41] = 8;
        sArray[42] = 10;
        sArray[43] = 5;
        sArray[44] = 9;
        sArray[45] = 11;
        sArray[46] = 6;
        sArray[47] = 10;
        sArray[48] = 11;
        sArray[49] = 7;
        sArray[50] = 6;
        sArray[51] = 11;
        sArray[52] = 8;
        sArray[53] = 7;
        sArray[54] = 11;
        sArray[55] = 9;
        sArray[56] = 8;
        sArray[57] = 11;
        sArray[58] = 10;
        sArray[59] = 9;
        faceVertexesIcosahedron = sArray;
        short[] sArray2 = new short[72];
        sArray2[0] = 1;
        sArray2[1] = 2;
        sArray2[2] = 3;
        sArray2[3] = 4;
        sArray2[4] = 5;
        sArray2[5] = -1;
        sArray2[7] = 5;
        sArray2[8] = 10;
        sArray2[9] = 6;
        sArray2[10] = 2;
        sArray2[11] = -1;
        sArray2[13] = 1;
        sArray2[14] = 6;
        sArray2[15] = 7;
        sArray2[16] = 3;
        sArray2[17] = -1;
        sArray2[19] = 2;
        sArray2[20] = 7;
        sArray2[21] = 8;
        sArray2[22] = 4;
        sArray2[23] = -1;
        sArray2[25] = 3;
        sArray2[26] = 8;
        sArray2[27] = 9;
        sArray2[28] = 5;
        sArray2[29] = -1;
        sArray2[31] = 4;
        sArray2[32] = 9;
        sArray2[33] = 10;
        sArray2[34] = 1;
        sArray2[35] = -1;
        sArray2[36] = 1;
        sArray2[37] = 10;
        sArray2[38] = 11;
        sArray2[39] = 7;
        sArray2[40] = 2;
        sArray2[41] = -1;
        sArray2[42] = 2;
        sArray2[43] = 6;
        sArray2[44] = 11;
        sArray2[45] = 8;
        sArray2[46] = 3;
        sArray2[47] = -1;
        sArray2[48] = 3;
        sArray2[49] = 7;
        sArray2[50] = 11;
        sArray2[51] = 9;
        sArray2[52] = 4;
        sArray2[53] = -1;
        sArray2[54] = 4;
        sArray2[55] = 8;
        sArray2[56] = 11;
        sArray2[57] = 10;
        sArray2[58] = 5;
        sArray2[59] = -1;
        sArray2[60] = 5;
        sArray2[61] = 9;
        sArray2[62] = 11;
        sArray2[63] = 6;
        sArray2[64] = 1;
        sArray2[65] = -1;
        sArray2[66] = 6;
        sArray2[67] = 7;
        sArray2[68] = 8;
        sArray2[69] = 9;
        sArray2[70] = 10;
        sArray2[71] = -1;
        neighborVertexesIcosahedron = sArray2;
    }

    public static short[][] getNeighborVertexesArrays() {
        if (vertexCounts == null) {
            Geodesic.createGeodesic(3);
        }
        return neighborVertexesArrays;
    }

    public static short getVertexCount(int n) {
        if (vertexCounts == null) {
            Geodesic.createGeodesic(3);
        }
        return vertexCounts[n];
    }

    public static V3[] getVertexVectors() {
        if (vertexCounts == null) {
            Geodesic.createGeodesic(3);
        }
        return vertexVectors;
    }

    public static V3 getVertexVector(int n) {
        return vertexVectors[n];
    }

    public static short[] getFaceVertexes(int n) {
        return faceVertexesArrays[n];
    }

    public static synchronized void createGeodesic(int n) {
        if (n < currentLevel) {
            return;
        }
        currentLevel = n;
        short[] sArray = new short[n + 1];
        neighborVertexesArrays = AU.newShort2(n + 1);
        faceVertexesArrays = AU.newShort2(n + 1);
        vertexVectors = new V3[12];
        Geodesic.vertexVectors[0] = V3.new3(0.0f, 0.0f, halfRoot5);
        int n2 = 0;
        while (n2 < 5) {
            Geodesic.vertexVectors[n2 + 1] = V3.new3((float)Math.cos((float)n2 * 1.2566371f), (float)Math.sin((float)n2 * 1.2566371f), 0.5f);
            Geodesic.vertexVectors[n2 + 6] = V3.new3((float)Math.cos((float)n2 * 1.2566371f + 0.62831855f), (float)Math.sin((float)n2 * 1.2566371f + 0.62831855f), -0.5f);
            ++n2;
        }
        Geodesic.vertexVectors[11] = V3.new3(0.0f, 0.0f, -halfRoot5);
        n2 = 12;
        while (--n2 >= 0) {
            vertexVectors[n2].normalize();
        }
        Geodesic.faceVertexesArrays[0] = faceVertexesIcosahedron;
        Geodesic.neighborVertexesArrays[0] = neighborVertexesIcosahedron;
        sArray[0] = 12;
        n2 = 0;
        while (n2 < n) {
            Geodesic.quadruple(n2, sArray);
            ++n2;
        }
        vertexCounts = sArray;
    }

    private static void quadruple(int n, short[] sArray) {
        short s;
        short s2;
        short s3;
        short s4;
        htVertex = new Hashtable<Integer, Short>();
        int n2 = vertexVectors.length;
        short[] sArray2 = faceVertexesArrays[n];
        int n3 = sArray2.length;
        int n4 = n3 / 3;
        int n5 = n2 + n4 - 2;
        int n6 = n2 + n5;
        int n7 = 4 * n4;
        vertexVectors = (V3[])AU.arrayCopyObject(vertexVectors, n6);
        short[] sArray3 = new short[3 * n7];
        Geodesic.faceVertexesArrays[n + 1] = sArray3;
        short[] sArray4 = new short[6 * n6];
        Geodesic.neighborVertexesArrays[n + 1] = sArray4;
        int n8 = sArray4.length;
        while (--n8 >= 0) {
            sArray4[n8] = -1;
        }
        sArray[n + 1] = (short)n6;
        vertexNext = (short)n2;
        n8 = 0;
        int n9 = 0;
        while (n9 < n3) {
            s4 = sArray2[n9++];
            s3 = sArray2[n9++];
            s2 = sArray2[n9++];
            s = Geodesic.getVertex(s4, s3);
            short s5 = Geodesic.getVertex(s3, s2);
            short s6 = Geodesic.getVertex(s2, s4);
            sArray3[n8++] = s4;
            sArray3[n8++] = s;
            sArray3[n8++] = s6;
            sArray3[n8++] = s3;
            sArray3[n8++] = s5;
            sArray3[n8++] = s;
            sArray3[n8++] = s2;
            sArray3[n8++] = s6;
            sArray3[n8++] = s5;
            sArray3[n8++] = s6;
            sArray3[n8++] = s;
            sArray3[n8++] = s5;
            Geodesic.addNeighboringVertexes(sArray4, s, s4);
            Geodesic.addNeighboringVertexes(sArray4, s, s6);
            Geodesic.addNeighboringVertexes(sArray4, s, s5);
            Geodesic.addNeighboringVertexes(sArray4, s, s3);
            Geodesic.addNeighboringVertexes(sArray4, s5, s3);
            Geodesic.addNeighboringVertexes(sArray4, s5, s6);
            Geodesic.addNeighboringVertexes(sArray4, s5, s2);
            Geodesic.addNeighboringVertexes(sArray4, s6, s2);
            Geodesic.addNeighboringVertexes(sArray4, s6, s4);
        }
        n9 = vertexVectors.length;
        if (n8 != sArray3.length) {
            throw new NullPointerException();
        }
        if (vertexNext != n6) {
            throw new NullPointerException();
        }
        s4 = 0;
        while (s4 < 12) {
            s3 = 0;
            while (s3 < 5) {
                s2 = sArray4[s4 * 6 + s3];
                if (s2 < 0) {
                    throw new NullPointerException();
                }
                if (s2 >= n9) {
                    throw new NullPointerException();
                }
                if (sArray4[s4 * 6 + 5] != -1) {
                    throw new NullPointerException();
                }
                ++s3;
            }
            ++s4;
        }
        s4 = 72;
        while (s4 < sArray4.length) {
            s3 = sArray4[s4];
            if (s3 < 0) {
                throw new NullPointerException();
            }
            if (s3 >= n9) {
                throw new NullPointerException();
            }
            ++s4;
        }
        s4 = 0;
        while (s4 < n6) {
            s3 = 0;
            s2 = sArray4.length;
            while (--s2 >= 0) {
                if (sArray4[s2] != s4) continue;
                ++s3;
            }
            if (s4 < 12 && s3 != 5 || s4 >= 12 && s3 != 6) {
                throw new NullPointerException();
            }
            s2 = 0;
            s = sArray3.length;
            while (--s >= 0) {
                if (sArray3[s] != s4) continue;
                ++s2;
            }
            if (s4 < 12 && s2 != 5 || s4 >= 12 && s2 != 6) {
                throw new NullPointerException();
            }
            ++s4;
        }
        htVertex = null;
    }

    private static void addNeighboringVertexes(short[] sArray, short s, short s2) {
        int n = s * 6;
        int n2 = n + 6;
        while (n < n2) {
            if (sArray[n] == s2) {
                return;
            }
            if (sArray[n] < 0) {
                sArray[n] = s2;
                int n3 = s2 * 6;
                int n4 = n3 + 6;
                while (n3 < n4) {
                    if (sArray[n3] == s) {
                        return;
                    }
                    if (sArray[n3] < 0) {
                        sArray[n3] = s;
                        return;
                    }
                    ++n3;
                }
            }
            ++n;
        }
        throw new NullPointerException();
    }

    private static short getVertex(short s, short s2) {
        Integer n;
        Short s3;
        if (s > s2) {
            short s4 = s;
            s = s2;
            s2 = s4;
        }
        if ((s3 = htVertex.get(n = Integer.valueOf((s << 16) + s2))) != null) {
            return s3;
        }
        V3 v3 = Geodesic.vertexVectors[Geodesic.vertexNext] = new V3();
        v3.add2(vertexVectors[s], vertexVectors[s2]);
        v3.normalize();
        htVertex.put(n, vertexNext);
        short s5 = vertexNext;
        vertexNext = (short)(s5 + 1);
        return s5;
    }
}

