/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapesurface;

import javajs.util.BS;
import javajs.util.OC;
import javajs.util.T3;
import org.jmol.shapesurface.IsosurfaceMesh;
import org.jmol.util.C;

public class PMeshWriter {
    private IsosurfaceMesh imesh;
    boolean isBinary;
    private OC oc;
    private int i0;
    private int[][] polygonIndexes;
    private boolean selectedPolyOnly;
    private BS bsPolygons;
    private boolean haveBsDisplay;
    private boolean colorSolid;
    private boolean colorArrayed;
    private short cx;
    private short[] vertexColixes;
    private boolean noColor;
    private short[] contourColixes;
    private float[] vertexValues;
    private int vertexCount;
    private int[] imap;

    Object write(IsosurfaceMesh isosurfaceMesh, boolean bl) {
        this.imesh = isosurfaceMesh;
        this.isBinary = bl;
        BS bS = new BS();
        BS bS2 = new BS();
        BS bS3 = new BS();
        if (this.imesh.showPoints || this.imesh.pc <= 0) {
            this.checkPoints(bS3);
        }
        bS2.or(bS3);
        if (this.imesh.drawTriangles) {
            this.checkTriangles(false, bS, bS2);
        }
        if (this.imesh.pc > 0 && this.imesh.fillTriangles) {
            this.checkTriangles(true, bS, bS2);
        }
        this.imap = new int[this.vertexCount];
        int[] nArray = new int[this.vertexCount];
        int n = 0;
        int n2 = bS2.nextSetBit(0);
        while (n2 >= 0) {
            nArray[n] = n2;
            this.imap[n2] = n++;
            n2 = bS2.nextSetBit(n2 + 1);
        }
        this.writePmeshHeader(n);
        if (!bl) {
            this.outputInt(n);
        }
        n2 = 0;
        while (n2 < n) {
            this.outputXYZ(this.imesh.vs[nArray[n2]]);
            ++n2;
        }
        if (!bl) {
            this.outputInt(-1);
        }
        if (this.imesh.showPoints || this.imesh.pc <= 0) {
            this.outputPoints(bS3);
        }
        bS2.or(bS3);
        BS bS4 = new BS();
        if (this.imesh.drawTriangles) {
            this.outputTriangles(false, bS, bS4);
        }
        if (this.imesh.pc > 0 && this.imesh.fillTriangles) {
            this.outputTriangles(true, bS, bS4);
        }
        if (bl) {
            this.oc.writeInt(0);
        } else {
            this.oc.append("0\n");
        }
        this.oc.closeChannel();
        return bl ? this.oc.toByteArray() : (byte[])this.oc.toString();
    }

    private void outputPoints(BS bS) {
        int n = C.getArgb(this.cx);
        int n2 = bS.nextSetBit(0);
        while (n2 >= 0) {
            if (!this.imesh.isColorSolid && this.imesh.vcs != null) {
                this.cx = this.imesh.vcs[n2];
                n = C.getArgb(this.cx);
            }
            this.outputPoint(this.imap[n2], n);
            n2 = bS.nextSetBit(n2 + 1);
        }
    }

    private void outputTriangles(boolean bl, BS bS, BS bS2) {
        int n = C.getArgb(this.cx);
        int n2 = bS.nextSetBit(0);
        while (n2 >= 0) {
            int n3;
            int[] nArray = this.polygonIndexes[n2];
            int n4 = this.imap[nArray[0]];
            int n5 = this.imap[nArray[1]];
            int n6 = this.imap[nArray[2]];
            if (this.colorSolid) {
                if (this.colorArrayed && n2 < this.imesh.pcs.length) {
                    this.cx = this.imesh.pcs[n2];
                }
            } else {
                this.cx = this.vertexColixes[nArray[0]];
            }
            n = C.getArgb(this.cx);
            if (bl) {
                if (n5 == n6) {
                    if (n4 == n5) {
                        this.outputPoint(n4, n);
                    } else {
                        this.outputEdge(n4, n5, n);
                    }
                    bS2.set(n2);
                } else {
                    if (this.imesh.colorsExplicit) {
                        n = nArray[4];
                    }
                    this.outputTriangle(n4, n5, n6, n, 999);
                }
            } else if (!bS2.get(n2) && (n3 = 7 & nArray[3]) != 0) {
                if (!this.noColor && this.colorArrayed) {
                    n = C.getArgb(this.imesh.fillTriangles ? (short)4 : this.contourColixes[nArray[4] % this.contourColixes.length]);
                }
                this.outputTriangle(n4, n5, n6, n, n3);
            }
            n2 = bS.nextSetBit(n2 + 1);
        }
    }

    private void checkPoints(BS bS) {
        boolean bl = this.imesh.pc == 0 && this.selectedPolyOnly;
        int n = this.imesh.vertexIncrement;
        int n2 = !this.imesh.hasGridPoints || this.imesh.firstRealVertex < 0 ? 0 : this.imesh.firstRealVertex;
        while (n2 < this.vertexCount) {
            if (!(this.vertexValues != null && Float.isNaN(this.vertexValues[n2]) || this.imesh.jvxlData.thisSet >= 0 && this.imesh.vertexSets[n2] != this.imesh.jvxlData.thisSet || !this.imesh.isColorSolid || this.haveBsDisplay && !this.imesh.bsDisplay.get(n2) || bl && !this.bsPolygons.get(n2))) {
                bS.set(n2);
            }
            n2 += n;
        }
    }

    private void checkTriangles(boolean bl, BS bS, BS bS2) {
        this.setup(bl);
        int n = this.imesh.pc;
        while (--n >= 0) {
            int[] nArray = this.polygonIndexes[n];
            if (nArray == null || this.selectedPolyOnly && !this.bsPolygons.get(n)) continue;
            int n2 = nArray[0];
            if (this.imesh.jvxlData.thisSet >= 0 && this.imesh.vertexSets != null && this.imesh.vertexSets[n2] != this.imesh.jvxlData.thisSet) continue;
            int n3 = nArray[1];
            int n4 = nArray[2];
            if (this.haveBsDisplay && (!this.imesh.bsDisplay.get(n2) || !this.imesh.bsDisplay.get(n3) || !this.imesh.bsDisplay.get(n4)) || this.colorSolid && this.colorArrayed && n < this.imesh.pcs.length && this.imesh.pcs[n] == 0) continue;
            bS.set(n);
            bS2.set(n2);
            bS2.set(n3);
            bS2.set(n4);
        }
    }

    private void setup(boolean bl) {
        this.vertexCount = this.imesh.vc;
        this.vertexValues = this.imesh.vvs;
        this.polygonIndexes = this.imesh.pis;
        this.cx = !bl && this.imesh.meshColix != 0 ? this.imesh.meshColix : this.imesh.colix;
        this.vertexColixes = (short[])(!bl && this.imesh.meshColix != 0 ? null : this.imesh.vcs);
        this.colorSolid = this.vertexColixes == null;
        this.noColor = this.vertexColixes == null || !bl && this.imesh.meshColix != 0;
        boolean bl2 = this.colorArrayed = this.colorSolid && this.imesh.pcs != null;
        if (this.colorArrayed && !bl && this.imesh.fillTriangles) {
            this.colorArrayed = false;
        }
        this.contourColixes = this.imesh.jvxlData.contourColixes;
        this.haveBsDisplay = this.imesh.bsDisplay != null;
        this.selectedPolyOnly = this.imesh.bsSlabDisplay != null;
        this.bsPolygons = this.selectedPolyOnly ? this.imesh.bsSlabDisplay : null;
    }

    private void writePmeshHeader(int n) {
        this.oc = this.imesh.vwr.getOutputChannel(null, null);
        if (this.isBinary) {
            this.oc.writeByteAsInt(80);
            this.oc.writeByteAsInt(77);
            this.oc.writeByteAsInt(1);
            this.oc.writeByteAsInt(0);
            this.oc.writeInt(1);
            this.oc.writeInt(n);
            this.oc.writeInt(-1);
            int n2 = 0;
            while (n2 < 16) {
                this.oc.writeInt(0);
                ++n2;
            }
        } else {
            this.oc.append("#JmolPmesh\n");
        }
    }

    private void outputInt(int n) {
        if (this.isBinary) {
            this.oc.writeInt(n);
        } else {
            this.oc.append(n + "\n");
        }
    }

    private int outputPoint(int n, int n2) {
        this.outputInt(-1);
        this.outputInt(n);
        this.outputInt(n2);
        return 1;
    }

    private void outputXYZ(T3 t3) {
        if (this.isBinary) {
            this.oc.writeFloat(t3.x);
            this.oc.writeFloat(t3.y);
            this.oc.writeFloat(t3.z);
        } else {
            this.oc.append(String.valueOf(t3.x) + " " + t3.y + " " + t3.z + "\n");
        }
    }

    private void outputEdge(int n, int n2, int n3) {
        this.outputInt(-2);
        this.outputInt(n);
        this.outputInt(n2);
        this.outputInt(n3);
    }

    private void outputTriangle(int n, int n2, int n3, int n4, int n5) {
        if (n5 == 999) {
            this.outputInt(-3);
            this.outputInt(n);
            this.outputInt(n2);
            this.outputInt(n3);
            this.outputInt(n4);
            return;
        }
        if ((n5 & 1) != 0) {
            this.outputEdge(n, n2, n4);
        }
        if ((n5 & 2) != 0) {
            this.outputEdge(n2, n3, n4);
        }
        if ((n5 & 4) != 0) {
            this.outputEdge(n3, n, n4);
        }
    }
}

