/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.modelset.Atom;
import org.jmol.viewer.Viewer;

public class NBOParser {
    private Viewer vwr;
    private boolean haveBeta;

    public NBOParser set(Viewer viewer) {
        this.vwr = viewer;
        return this;
    }

    public Lst<Object> getAllStructures(String string, Lst<Object> lst) {
        if (string == null) {
            return null;
        }
        if (lst == null) {
            lst = new Lst();
        }
        string = PT.rep(string, "the $CHOOSE", "");
        this.getStructures(this.getBlock(string, "$CHOOSE"), "CHOOSE", lst);
        this.getStructures(this.getBlock(string, "$NRTSTR"), "NRTSTR", lst);
        this.getStructures(this.getBlock(string, "$NRTSTRA"), "NRTSTRA", lst);
        this.getStructures(this.getBlock(string, "$NRTSTRB"), "NRTSTRB", lst);
        this.getStructuresTOPO(this.getData(string, "TOPO matrix", "* Total *", 1), "RSA", lst);
        this.getStructuresTOPO(this.getData(string, "TOPO matrix", "* Total *", 2), "RSB", lst);
        return lst;
    }

    private String getBlock(String string, String string2) {
        int n = string.indexOf(string2);
        int n2 = string.indexOf("$END", n + 1);
        return n < 0 || n2 < 0 ? null : string.substring(n + string2.length(), n2);
    }

    public static void getStructures46(String[] stringArray, String string, Lst<Object> lst, int n) {
        if (stringArray == null) {
            return;
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        lst.addLast(hashtable);
        int[][] nArray = new int[n][n];
        hashtable.put("matrix", nArray);
        hashtable.put("type", string);
        hashtable.put("spin", string);
        hashtable.put("index", 0);
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string2 = stringArray[n3];
            if (string2.contains("(ry)")) break;
            if (!string2.contains("*") && !string2.contains("(cr)")) {
                boolean bl = string2.endsWith("(lp)");
                if (bl || string2.endsWith("(lv)")) {
                    int n4 = NBOParser.getAtomIndex(string2.substring(0, string2.length() - 4));
                    int[] nArray2 = nArray[n4];
                    int n5 = n4;
                    nArray2[n5] = nArray2[n5] + (bl ? 1 : 10);
                } else {
                    String[] stringArray2 = PT.split(string2, "-");
                    if (stringArray2.length == 3) {
                        System.out.println("NBOParser 3-center bonnd " + string2 + " ignored for Kekule structure");
                    } else {
                        int n6 = NBOParser.getAtomIndex(stringArray2[0]);
                        int n7 = NBOParser.getAtomIndex(stringArray2[1]);
                        int[] nArray3 = nArray[n6];
                        int n8 = n7;
                        nArray3[n8] = nArray3[n8] + 1;
                    }
                }
            }
            ++n3;
        }
        NBOParser.dumpMatrix(string, 0, nArray);
    }

    private static int getAtomIndex(String string) {
        int n;
        int n2 = n = string.length();
        int n3 = 0;
        int n4 = 1;
        char c = '\u0000';
        while (--n2 >= 0) {
            c = string.charAt(n2);
            if (c < '0' || c > '9') {
                return n3 - 1;
            }
            n3 += (c - 48) * n4;
            n4 *= 10;
        }
        return 0;
    }

    private void getStructuresTOPO(String string, String string2, Lst<Object> lst) {
        if (string == null || string.length() == 0) {
            return;
        }
        String[] stringArray = PT.split(string, "Resonance");
        if (stringArray.length < 2) {
            return;
        }
        int n = stringArray[0].lastIndexOf(".");
        int n2 = PT.parseInt(stringArray[0].substring(n - 3, n));
        if (n2 < 0) {
            return;
        }
        String[] stringArray2 = PT.getTokens(PT.rep(PT.rep(stringArray[0], ".", ".1"), "Atom", "-1"));
        float[] fArray = new float[stringArray2.length];
        int n3 = PT.parseFloatArrayInfested(stringArray2, fArray);
        int[][] nArray = new int[n2][n2];
        int n4 = -1;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n3) {
            float f = fArray[n7];
            if (f < 0.0f) {
                n4 = -1;
            } else if (f % 1.0f == 0.0f) {
                if (n4 == -1) {
                    n6 = (int)f;
                    n4 = -2;
                }
                if (n4 >= 0) {
                    nArray[n4][n5++] = (int)f;
                }
            } else {
                n4 = (int)(f - 1.0f);
                n5 = n6 - 1;
            }
            ++n7;
        }
        int[][] nArray2 = null;
        stringArray2 = stringArray[1].split("\n");
        String string3 = "";
        int n8 = 3;
        while (n8 < stringArray2.length) {
            if (stringArray2[n8].indexOf("--") < 0) {
                string3 = String.valueOf(string3) + stringArray2[n8].substring(10) + "\n";
            }
            ++n8;
        }
        string3 = string3.replace('-', ' ');
        string3 = PT.rep(string3, ".", ".1");
        string3 = PT.rep(string3, "(", " -1 ");
        string3 = PT.rep(string3, ")", " -2 ");
        string3 = PT.rep(string3, ",", " -3 ");
        stringArray2 = PT.getTokens(string3);
        fArray = new float[stringArray2.length];
        n3 = PT.parseFloatArrayInfested(stringArray2, fArray);
        Hashtable<String, Object> hashtable = null;
        int n9 = 1;
        n5 = -1;
        n4 = -1;
        int n10 = 0;
        int n11 = 0;
        while (n10 < n3) {
            block24: {
                int n12;
                float f;
                float f2;
                block23: {
                    f2 = fArray[n10];
                    f = f2 % 1.0f;
                    if (f != 0.0f) break block23;
                    n12 = (int)f2;
                    switch (n12) {
                        case -1: {
                            n9 = -1;
                            n5 = -1;
                            n4 = -1;
                            break block24;
                        }
                        case -2: {
                            break;
                        }
                        case -3: {
                            if (n4 >= 0) break;
                            break block24;
                        }
                        default: {
                            if (n4 < 0) {
                                n4 = n5 = n12 - 1;
                            } else {
                                n5 = n12 - 1;
                            }
                            break block24;
                        }
                    }
                    int[] nArray3 = nArray2[n4];
                    int n13 = n5;
                    nArray3[n13] = nArray3[n13] + n9;
                    n5 = -1;
                    n4 = -1;
                    n9 = 1;
                    break block24;
                }
                if (hashtable == null) {
                    nArray2 = nArray;
                }
                NBOParser.dumpMatrix(string2, n11, nArray2);
                if (fArray[n10 + 2] == 0.0f) break;
                hashtable = new Hashtable<String, Object>();
                lst.addLast(hashtable);
                string3 = "" + ((int)f2 * 100 + (int)(((double)f - 0.0999999) * 1000.0));
                n12 = string3.length();
                string3 = String.valueOf(n12 == 2 ? "0" : "") + string3.substring(0, n12 - 2) + "." + string3.substring(n12 - 2);
                hashtable.put("weight", string3);
                hashtable.put("index", n11++);
                hashtable.put("type", string2.toLowerCase());
                hashtable.put("spin", string2.indexOf("B") >= 0 ? "beta" : "alpha");
                nArray2 = new int[n2][n2];
                hashtable.put("matrix", nArray2);
                int n14 = 0;
                while (n14 < n2) {
                    int n15 = 0;
                    while (n15 < n2) {
                        nArray2[n14][n15] = nArray[n14][n15];
                        ++n15;
                    }
                    ++n14;
                }
            }
            ++n10;
        }
    }

    private static void dumpMatrix(String string, int n, int[][] nArray) {
        System.out.println("NBOParser matrix " + string + " " + n);
        int n2 = 0;
        int n3 = nArray.length;
        while (n2 < n3) {
            System.out.println(PT.toJSON(null, nArray[n2]));
            ++n2;
        }
        System.out.println("-------------------");
    }

    private String getData(String string, String string2, String string3, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            n2 = string.indexOf(string2, n3 + 1);
            n3 = string.indexOf(string3, n2 + 1);
            ++n4;
        }
        return n2 < 0 || n3 < 0 ? null : string.substring(n2, n3);
    }

    public int getStructures(String string, String string2, Lst<Object> lst) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        int n = 0;
        try {
            String string3;
            boolean bl;
            boolean bl2 = bl = string.indexOf("ALPHA") >= 0;
            if (!bl && !string.contains("STR")) {
                string = "STR " + string + " END";
            }
            String string4 = string3 = (string2 = string2.toLowerCase()).equals("nrtstrb") ? "beta" : "alpha";
            if (string2.equals("choose")) {
                string2 = null;
            }
            Hashtable<String, Object> hashtable = null;
            String[] stringArray = PT.getTokens(string.replace('\r', ' ').replace('\n', ' ').replace('\t', ' '));
            String string5 = "";
            int n2 = 0;
            int n3 = 0;
            int n4 = stringArray.length;
            while (n3 < n4) {
                String string6 = stringArray[n3];
                switch ("STR  =    ALPHABETA LONE BOND 3C".indexOf(string6)) {
                    case 0: {
                        if (bl) break;
                        string6 = string3;
                    }
                    case 10: 
                    case 15: {
                        hashtable = new Hashtable<String, Object>();
                        lst.addLast(hashtable);
                        if (!string5.equals(string6)) {
                            string5 = string6;
                            n2 = 0;
                        }
                        hashtable.put("index", n2++);
                        string3 = string6.toLowerCase();
                        hashtable.put("spin", string3);
                        if (string3.equals("beta")) {
                            this.haveBeta = true;
                        }
                        hashtable.put("type", string2 == null ? "choose" + string3.substring(0, 1) : string2);
                        ++n;
                        break;
                    }
                    case 5: {
                        hashtable.put("weight", stringArray[++n3]);
                        break;
                    }
                    case 20: {
                        Lst<int[]> lst2 = new Lst<int[]>();
                        hashtable.put("lone", lst2);
                        while (!(string6 = stringArray[++n3]).equals("END")) {
                            int n5 = Integer.parseInt(string6);
                            int n6 = Integer.parseInt(stringArray[++n3]);
                            lst2.addLast(new int[]{n6, n5});
                        }
                        break;
                    }
                    case 25: {
                        int n7;
                        int n8;
                        Lst<int[]> lst3 = new Lst<int[]>();
                        hashtable.put("bond", lst3);
                        while (!(string6 = stringArray[++n3]).equals("END")) {
                            int n9 = "DTQ".indexOf(string6.charAt(0)) + 2;
                            n8 = Integer.parseInt(stringArray[++n3]);
                            n7 = Integer.parseInt(stringArray[++n3]);
                            lst3.addLast(new int[]{n9, n8, n7});
                        }
                        break;
                    }
                    case 30: {
                        int n7;
                        int n8;
                        Lst<int[]> lst4 = new Lst<int[]>();
                        hashtable.put("3c", lst4);
                        while (!(string6 = stringArray[++n3]).equals("END")) {
                            n8 = "DTQ".indexOf(string6.charAt(0)) + 2;
                            n7 = Integer.parseInt(stringArray[++n3]);
                            int n10 = Integer.parseInt(stringArray[++n3]);
                            int n11 = Integer.parseInt(stringArray[++n3]);
                            lst4.addLast(new int[]{n8, n7, n10, n11});
                        }
                        break;
                    }
                }
                ++n3;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            lst.clear();
            return -1;
        }
        return n;
    }

    public boolean isOpenShell() {
        return this.haveBeta;
    }

    public static Map<String, Object> getStructureMap(Lst<Object> lst, String string, int n) {
        if (string == null || lst == null) {
            return null;
        }
        String string2 = (string = string.toLowerCase()).indexOf("b") < 0 ? "alpha" : "beta";
        int n2 = 0;
        while (n2 < lst.size()) {
            Map map = (Map)lst.get(n2);
            if (string2.equals(map.get("spin")) && string.equals(map.get("type")) && (n < 0 || n == (Integer)map.get("index"))) {
                return map;
            }
            ++n2;
        }
        return null;
    }

    public boolean connectNBO(int n, String object) {
        Object object2;
        Map<String, Object> map;
        block10: {
            Lst lst;
            block9: {
                try {
                    if (object == null) {
                        object = "alpha";
                    }
                    if (((String)(object = ((String)object).toLowerCase())).length() == 0 || ((String)object).equals("46")) {
                        object = "alpha";
                    }
                    map = this.vwr.ms.getModelAuxiliaryInfo(n);
                    this.haveBeta = map.containsKey("isOpenShell");
                    lst = (Lst)map.get("nboStructures");
                    if (lst != null && lst.size() != 0) break block9;
                    return false;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    return false;
                }
            }
            object = ((String)object).toLowerCase();
            int n2 = ((String)object).indexOf("_");
            if (n2 > 0) {
                if (lst.size() <= 2 && (object2 = (String)map.get("fileName")) != null && !((String)object2).endsWith(".nbo")) {
                    object2 = String.valueOf(((String)object2).substring(0, ((String)object2).lastIndexOf("."))) + ".nbo";
                    this.getAllStructures(this.vwr.getAsciiFileOrNull((String)object2), lst);
                }
                object2 = PT.split((String)object, "_");
                n2 = PT.parseInt(object2[1]) - 1;
                object = object2[0];
            } else {
                n2 = 0;
            }
            object2 = NBOParser.getStructureMap(lst, (String)object, n2);
            if (object2 != null && this.setJmolLewisStructure((Map<String, Object>)object2, n, n2 + 1)) break block10;
            return false;
        }
        map.put("nboStructure", object2);
        return true;
    }

    private boolean setJmolLewisStructure(Map<String, Object> map, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        if (map == null || n < 0) {
            return false;
        }
        String string = (String)map.get("type");
        System.out.println("creating structure " + n + " " + string);
        Lst lst = (Lst)map.get("bond");
        Lst lst2 = (Lst)map.get("lone");
        int[][] nArray = (int[][])map.get("matrix");
        int[] nArray2 = (int[])map.get("lplv");
        int[] nArray3 = (int[])map.get("bondCounts");
        boolean bl = nArray2 == null;
        BS bS = this.vwr.ms.getModelAtomBitSetIncludingDeleted(n, false);
        int n7 = bS.cardinality();
        int n8 = bS.nextSetBit(0);
        if (nArray != null && n7 != nArray.length) {
            return false;
        }
        if (nArray != null) {
            NBOParser.dumpMatrix(string, n2, nArray);
        }
        if (bl) {
            nArray2 = new int[n7];
            map.put("lplv", nArray2);
            nArray3 = new int[n7];
            map.put("bondCounts", nArray3);
        }
        if (bl) {
            if (lst2 != null) {
                n6 = lst2.size();
                while (--n6 >= 0) {
                    int[] nArray4 = (int[])lst2.get(n6);
                    n5 = nArray4[0];
                    n4 = nArray4[1] - 1;
                    nArray2[n4] = n5;
                }
            } else if (nArray != null) {
                n6 = n7;
                while (--n6 >= 0) {
                    nArray2[n6] = nArray[n6][n6];
                }
            }
        }
        this.vwr.ms.deleteModelBonds(n);
        n6 = this.vwr.ms.getDefaultMadFromOrder(1);
        if (lst != null) {
            int n9 = lst.size();
            while (--n9 >= 0) {
                int[] nArray5 = (int[])lst.get(n9);
                n4 = n8 + nArray5[1] - 1;
                n3 = n8 + nArray5[2] - 1;
                int n10 = nArray5[0];
                if (bl) {
                    int n11 = n4;
                    nArray3[n11] = nArray3[n11] + n10;
                    int n12 = n3;
                    nArray3[n12] = nArray3[n12] + n10;
                }
                this.vwr.ms.bondAtoms(this.vwr.ms.at[n4], this.vwr.ms.at[n3], n10, (short)n6, bS, 0.0f, true, true);
            }
        } else if (nArray != null) {
            int n13 = 0;
            while (n13 < n7 - 1) {
                int[] nArray6 = nArray[n13];
                n4 = n13 + 1;
                while (n4 < n7) {
                    n3 = nArray6[n4];
                    if (n3 != 0) {
                        System.out.println("adding bond " + this.vwr.ms.at[n13 + n8] + " " + this.vwr.ms.at[n4 + n8]);
                        this.vwr.ms.bondAtoms(this.vwr.ms.at[n13 + n8], this.vwr.ms.at[n4 + n8], n3, (short)n6, null, 0.0f, false, true);
                        if (bl) {
                            int n14 = n13;
                            nArray3[n14] = nArray3[n14] + n3;
                            int n15 = n4;
                            nArray3[n15] = nArray3[n15] + n3;
                        }
                    }
                    ++n4;
                }
                ++n13;
            }
        }
        int n16 = 0;
        n5 = bS.nextSetBit(0);
        while (n5 >= 0) {
            Atom atom = this.vwr.ms.at[n5];
            atom.setValence(nArray3[n16]);
            atom.setFormalCharge(0);
            n3 = this.vwr.ms.getMissingHydrogenCount(atom, true);
            if (atom.getElementNumber() == 6 && n3 == 1 && (nArray3[n16] == 3 && nArray2[n16] % 10 == 0 || nArray3[n16] == 2)) {
                n3 -= 2;
            }
            atom.setFormalCharge(-n3);
            n5 = bS.nextSetBit(n5 + 1);
            ++n16;
        }
        return true;
    }

    public String getNBOAtomLabel(Atom atom) {
        int n;
        String string = atom.getAtomName();
        int n2 = atom.getModelIndex();
        Map map = (Map)this.vwr.ms.getModelAuxiliaryInfo(n2).get("nboStructure");
        if (this.vwr == null || map == null) {
            return string;
        }
        int[] nArray = (int[])map.get("lplv");
        int n3 = atom.i - this.vwr.ms.am[n2].firstAtomIndex;
        boolean bl = this.vwr.getBoolean(603979891);
        int n4 = n = bl ? this.vwr.ms.at[n3].getFormalCharge() : 0;
        if (nArray[n3] == 0 && n == 0) {
            return string;
        }
        if (nArray[n3] % 10 > 0) {
            string = "<sup>(" + nArray[n3] % 10 + ")</sup>" + string;
        }
        if (nArray[n3] >= 10) {
            string = "*" + string;
        }
        if (bl && n != 0) {
            string = String.valueOf(string) + "<sup>" + Math.abs(n) + (n > 0 ? "+" : (n < 0 ? "-" : "")) + "</sup>";
        }
        return string;
    }
}

