/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.util.Map;
import javajs.util.BS;
import javajs.util.P3;
import javajs.util.SB;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Escape;
import org.jmol.util.Logger;

public class BinaryDcdReader
extends AtomSetCollectionReader {
    private int nModels;
    private int nAtoms;
    private int nFree;
    private BS bsFree;
    private float[] xAll;
    private float[] yAll;
    private float[] zAll;
    private int crystGroup;

    @Override
    protected void setup(String string, Map<String, Object> map, Object object) {
        this.isBinary = true;
        this.requiresBSFilter = true;
        this.setupASCR(string, map, object);
    }

    @Override
    protected void initializeReader() {
        this.initializeTrajectoryFile();
        this.asc.setInfo("ignoreUnitCell", Boolean.TRUE);
    }

    @Override
    protected void processBinaryDocument() throws Exception {
        byte[] byArray = new byte[40];
        this.binaryDoc.setStream(null, this.binaryDoc.readInt() == 84);
        this.binaryDoc.readInt();
        this.nModels = this.binaryDoc.readInt();
        int n = this.binaryDoc.readInt();
        int n2 = this.binaryDoc.readInt();
        int n3 = this.binaryDoc.readInt();
        this.binaryDoc.readInt();
        this.binaryDoc.readInt();
        this.binaryDoc.readInt();
        int n4 = this.binaryDoc.readInt();
        this.nFree = n4 / 3;
        int n5 = this.binaryDoc.readInt();
        int n6 = this.binaryDoc.readInt();
        this.crystGroup = this.binaryDoc.readInt();
        this.binaryDoc.readByteArray(byArray, 0, 32);
        this.binaryDoc.readInt();
        this.binaryDoc.readInt();
        this.binaryDoc.readInt();
        SB sB = new SB();
        int n7 = 0;
        int n8 = this.binaryDoc.readInt();
        while (n7 < n8) {
            sB.append(this.trimString(this.binaryDoc.readString(80))).appendC('\n');
            ++n7;
        }
        this.binaryDoc.readInt();
        Logger.info("BinaryDcdReadaer:\n" + sB);
        this.binaryDoc.readInt();
        this.nAtoms = this.binaryDoc.readInt();
        this.binaryDoc.readInt();
        this.nFree = this.nAtoms - n5;
        if (n5 != 0) {
            this.binaryDoc.readInt();
            this.bsFree = BS.newN(this.nFree);
            n7 = 0;
            while (n7 < this.nFree) {
                this.bsFree.set(this.binaryDoc.readInt() - 1);
                ++n7;
            }
            this.binaryDoc.readInt();
            Logger.info("free: " + this.bsFree.cardinality() + " " + Escape.eBS(this.bsFree));
        }
        this.readCoordinates();
        Logger.info("Total number of trajectory steps=" + this.trajectorySteps.size());
    }

    private String trimString(String string) {
        int n = string.indexOf(0);
        if (n >= 0) {
            string = string.substring(0, n);
        }
        return string.trim();
    }

    private float[] readFloatArray() throws Exception {
        int n = this.binaryDoc.readInt() / 4;
        float[] fArray = new float[n];
        int n2 = 0;
        while (n2 < n) {
            fArray[n2] = this.binaryDoc.readFloat();
            ++n2;
        }
        this.binaryDoc.readInt();
        return fArray;
    }

    private double[] readDoubleArray() throws Exception {
        int n = this.binaryDoc.readInt() / 8;
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = this.binaryDoc.readDouble();
            ++n2;
        }
        this.binaryDoc.readInt();
        return dArray;
    }

    private void readCoordinates() throws Exception {
        int n = this.bsFilter == null ? this.templateAtomCount : (Integer)this.htParams.get("filteredAtomCount");
        int n2 = 0;
        while (n2 < this.nModels) {
            if (this.doGetModel(++this.modelNumber, null)) {
                P3[] p3Array = new P3[n];
                if (!this.getTrajectoryStep(p3Array)) {
                    return;
                }
                this.trajectorySteps.addLast(p3Array);
                if (this.isLastModel(this.modelNumber)) {
                    return;
                }
            } else {
                if (this.crystGroup > 0) {
                    this.readDoubleArray();
                }
                this.readFloatArray();
                this.readFloatArray();
                this.readFloatArray();
            }
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean getTrajectoryStep(P3[] p3Array) throws Exception {
        try {
            BS bS;
            int n = p3Array.length;
            int n2 = -1;
            if (this.crystGroup > 0) {
                this.calcUnitCell(this.readDoubleArray());
            }
            float[] fArray = this.readFloatArray();
            float[] fArray2 = this.readFloatArray();
            float[] fArray3 = this.readFloatArray();
            BS bS2 = bS = this.xAll == null ? null : this.bsFree;
            if (bS == null) {
                this.xAll = fArray;
                this.yAll = fArray2;
                this.zAll = fArray3;
            }
            int n3 = 0;
            int n4 = 0;
            while (true) {
                if (n3 >= this.nAtoms) {
                    return true;
                }
                P3 p3 = new P3();
                if (bS == null || bS.get(n3)) {
                    p3.set(fArray[n4], fArray2[n4], fArray3[n4]);
                    ++n4;
                } else {
                    p3.set(this.xAll[n3], this.yAll[n3], this.zAll[n3]);
                }
                if (this.bsFilter == null || this.bsFilter.get(n3)) {
                    if (++n2 == n) {
                        return true;
                    }
                    p3Array[n2] = p3;
                }
                ++n3;
            }
        }
        catch (Exception exception) {
            return false;
        }
    }

    private float[] calcUnitCell(double[] dArray) {
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        double d4 = dArray[3];
        double d5 = dArray[4];
        double d6 = dArray[5];
        double d7 = (1.5707963267948966 - Math.asin(d5)) * 180.0 / Math.PI;
        double d8 = (1.5707963267948966 - Math.asin(d4)) * 180.0 / Math.PI;
        double d9 = (1.5707963267948966 - Math.asin(d2)) * 180.0 / Math.PI;
        System.out.println("unitcell:[" + d + " " + d3 + " " + d6 + " " + d7 + " " + d8 + " " + d9 + "]");
        return new float[]{(float)d, (float)d3, (float)d6, (float)d7, (float)d8, (float)d9};
    }
}

