/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import javajs.awt.Font;
import javajs.util.BS;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.shape.Shape;
import org.jmol.util.C;
import org.jmol.util.Txt;
import org.jmol.viewer.JC;
import org.jmol.viewer.Viewer;

public class Text {
    private boolean isEcho;
    public boolean doFormatText;
    public String[] lines;
    public Font font;
    private byte fid;
    private int ascent;
    public int descent;
    private int lineHeight;
    protected int offsetX;
    protected int offsetY;
    private int textWidth;
    private int textHeight;
    public String text;
    public String textUnformatted;
    private int[] widths;
    private Viewer vwr;
    public Object image;
    public float imageScale = 1.0f;
    public int boxYoff2;
    private float xAdj;
    private float yAdj;
    private float y0;
    public P3 pointerPt;
    public boolean isLabelOrHover;
    public P3 xyz;
    public String target;
    public String script;
    public short colix;
    public short bgcolix;
    public int pointer;
    public float fontScale;
    public int align;
    public int valign;
    public int atomX;
    public int atomY;
    public int atomZ = Integer.MAX_VALUE;
    public int movableX;
    public int movableY;
    public int movableZ;
    public int movableXPercent = Integer.MAX_VALUE;
    public int movableYPercent = Integer.MAX_VALUE;
    public int movableZPercent = Integer.MAX_VALUE;
    public int z = 1;
    public int zSlab = Integer.MIN_VALUE;
    public float[] pymolOffset;
    protected int windowWidth;
    protected int windowHeight;
    public boolean adjustForWindow;
    public float boxWidth;
    public float boxHeight;
    public float boxX;
    public float boxY;
    public int modelIndex = -1;
    public boolean visible = true;
    public boolean hidden = false;
    public float[] boxXY = new float[5];
    public float scalePixelsPerMicron;

    public void setOffset(int n) {
        this.offsetX = JC.getXOffset(n);
        this.offsetY = JC.getYOffset(n);
        this.pymolOffset = null;
        this.valign = 3;
    }

    public static Text newLabel(Viewer viewer, Font font, String string, short s, short s2, int n, float f) {
        Text text = new Text();
        text.vwr = viewer;
        text.set(font, s, n, true, f);
        text.setText(string);
        text.bgcolix = s2;
        return text;
    }

    public static Text newEcho(Viewer viewer, Font font, String string, short s, int n, int n2, float f) {
        Text text = new Text();
        text.vwr = viewer;
        text.isEcho = true;
        text.set(font, s, n2, false, f);
        text.target = string;
        text.valign = n;
        text.z = 2;
        text.zSlab = Integer.MIN_VALUE;
        return text;
    }

    private void set(Font font, short s, int n, boolean bl, float f) {
        this.scalePixelsPerMicron = f;
        this.isLabelOrHover = bl;
        this.colix = s;
        this.align = n;
        this.setFont(font, bl);
    }

    private void getFontMetrics() {
        this.descent = this.font.getDescent();
        this.ascent = this.font.getAscent();
        this.lineHeight = this.ascent + this.descent;
    }

    public void setFontFromFid(byte by) {
        if (this.fid == by) {
            return;
        }
        this.fontScale = 0.0f;
        this.setFont(Font.getFont3D(by), true);
    }

    public void setText(String string) {
        if (this.image != null) {
            this.getFontMetrics();
        }
        this.image = null;
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (this.text != null && this.text.equals(string)) {
            return;
        }
        this.text = this.textUnformatted = string;
        boolean bl = this.doFormatText = this.isEcho && string != null && (string.indexOf("%{") >= 0 || string.indexOf("@{") >= 0);
        if (!this.doFormatText) {
            this.recalc();
        }
    }

    public void setImage(Object object) {
        this.image = object;
        this.recalc();
    }

    public void setScale(float f) {
        this.imageScale = f;
        this.recalc();
    }

    public void setFont(Font font, boolean bl) {
        this.font = font;
        if (this.font == null) {
            return;
        }
        this.getFontMetrics();
        if (!bl) {
            return;
        }
        this.fid = this.font.fid;
        this.recalc();
    }

    public void setFontScale(float f) {
        if (this.fontScale == f) {
            return;
        }
        this.fontScale = f;
        if (this.fontScale != 0.0f) {
            this.setFont(this.vwr.gdata.getFont3DScaled(this.font, f), true);
        }
    }

    private void recalc() {
        if (this.image != null) {
            this.textHeight = 0;
            this.textWidth = 0;
            this.boxWidth = (float)this.vwr.apiPlatform.getImageWidth(this.image) * this.fontScale * this.imageScale;
            this.boxHeight = (float)this.vwr.apiPlatform.getImageHeight(this.image) * this.fontScale * this.imageScale;
            this.ascent = 0;
            return;
        }
        if (this.text == null) {
            this.text = null;
            this.lines = null;
            this.widths = null;
            return;
        }
        if (this.font == null) {
            return;
        }
        this.lines = PT.split(this.text, this.text.indexOf("\n") >= 0 ? "\n" : "|");
        this.textWidth = 0;
        this.widths = new int[this.lines.length];
        int n = this.lines.length;
        while (--n >= 0) {
            this.widths[n] = this.stringWidth(this.lines[n]);
            this.textWidth = Math.max(this.textWidth, this.widths[n]);
        }
        this.textHeight = this.lines.length * this.lineHeight;
        this.boxWidth = this.textWidth + (this.fontScale >= 2.0f ? 16 : 8);
        this.boxHeight = this.textHeight + (this.fontScale >= 2.0f ? 16 : 8);
    }

    public void setPosition(float f, float f2, boolean bl, float[] fArray) {
        if (fArray == null) {
            fArray = this.boxXY;
        } else {
            this.boxXY = fArray;
        }
        this.setWindow(this.vwr.gdata.width, this.vwr.gdata.height, f);
        if (f != 0.0f && this.scalePixelsPerMicron != 0.0f) {
            this.setFontScale(f / this.scalePixelsPerMicron);
        } else if (this.fontScale != f2) {
            this.setFontScale(f2);
        }
        if (this.doFormatText) {
            this.text = this.isEcho ? Txt.formatText(this.vwr, this.textUnformatted) : this.textUnformatted;
            this.recalc();
        }
        float f3 = (float)this.offsetX * f2;
        float f4 = (float)this.offsetY * f2;
        this.xAdj = this.fontScale >= 2.0f ? 8 : 4;
        this.yAdj = (float)(this.ascent - this.lineHeight) + this.xAdj;
        if (this.isLabelOrHover || this.pymolOffset != null) {
            fArray[0] = this.movableX;
            fArray[1] = this.movableY;
            if (this.pymolOffset != null && this.pymolOffset[0] != 2.0f && this.pymolOffset[0] != 3.0f) {
                float f5 = this.vwr.tm.scaleToScreen(this.z, 1000);
                float f6 = this.pymolOffset[3];
                float f7 = (float)(f6 < 0.0f ? -1 : 1) * Math.max(0.0f, Math.abs(f6) - 1.0f) * f5;
                this.z -= (int)f7;
                f5 = this.vwr.tm.scaleToScreen(this.z, 1000);
                f3 = this.getPymolXYOffset(this.pymolOffset[1], this.textWidth, f5);
                int n = this.ascent - this.descent;
                f4 = -this.getPymolXYOffset(-this.pymolOffset[2], n, f5) - (float)((this.textHeight + n) / 2);
                if (this.pymolOffset[0] == 1.0f) {
                    f4 -= (float)this.descent;
                }
                this.xAdj = this.fontScale >= 2.0f ? 8 : 4;
                this.yAdj = -this.descent;
                fArray[0] = (float)this.movableX - this.xAdj;
                fArray[1] = (float)this.movableY - this.yAdj;
                bl = true;
                this.boxYoff2 = -2;
            } else {
                this.boxYoff2 = 0;
            }
            if (this.pymolOffset == null) {
                switch (this.align) {
                    case 8: {
                        f4 = 0.0f;
                        f3 = 0.0f;
                        break;
                    }
                    case 12: {
                        fArray[0] = fArray[0] - this.boxWidth;
                    }
                    case 4: {
                        f4 = 0.0f;
                    }
                }
            }
            Text.setBoxXY(this.boxWidth, this.boxHeight, f3, f4, fArray, bl);
        } else {
            this.setPos(this.fontScale);
        }
        this.boxX = fArray[0];
        this.boxY = fArray[1];
        if (this.adjustForWindow) {
            this.setBoxOffsetsInWindow(0.0f, this.isLabelOrHover ? 16.0f * this.fontScale + (float)this.lineHeight : 0.0f, this.boxY - (float)this.textHeight);
        }
        this.y0 = this.boxY + this.yAdj;
    }

    private float getPymolXYOffset(float f, int n, float f2) {
        float f3;
        float f4 = f < -1.0f ? -1.0f : (f3 = f > 1.0f ? 0.0f : (f - 1.0f) / 2.0f);
        f = f < -1.0f || f > 1.0f ? f + (float)(f < 0.0f ? 1 : -1) : 0.0f;
        return f3 * (float)n + f * f2;
    }

    private void setPos(float f) {
        float f2;
        float f3;
        float f4;
        float f5;
        boolean bl;
        boolean bl2 = bl = this.xyz != null;
        if (this.valign == 3 || this.valign == 4) {
            f5 = this.movableXPercent != Integer.MAX_VALUE ? (float)(this.movableXPercent * this.windowWidth / 100) : (bl ? (float)this.movableX : (float)this.movableX * f);
            float f6 = (float)this.offsetX * f;
            f3 = f4 = f5 + f6;
            f2 = f4;
        } else {
            f2 = 5.0f * f;
            f4 = this.windowWidth / 2;
            f3 = (float)this.windowWidth - f2;
        }
        this.boxXY[0] = f2;
        switch (this.align) {
            case 8: {
                this.boxXY[0] = f4 - this.boxWidth / 2.0f;
                break;
            }
            case 12: {
                this.boxXY[0] = f3 - this.boxWidth;
            }
        }
        this.boxXY[1] = 0.0f;
        switch (this.valign) {
            case 0: {
                break;
            }
            case 2: {
                this.boxXY[1] = this.windowHeight / 2;
                break;
            }
            case 1: {
                this.boxXY[1] = this.windowHeight;
                break;
            }
            default: {
                f5 = this.movableYPercent != Integer.MAX_VALUE ? (float)(this.movableYPercent * this.windowHeight / 100) : (bl ? (float)this.movableY : (float)this.movableY * f);
                this.boxXY[1] = (bl ? f5 : (float)this.windowHeight - f5) + (float)this.offsetY * f;
            }
        }
        if (this.align == 8) {
            this.boxXY[1] = this.boxXY[1] - (this.image != null ? this.boxHeight : (this.xyz != null ? this.boxHeight : (float)this.ascent - this.boxHeight)) / 2.0f;
        } else if (this.image != null) {
            this.boxXY[1] = this.boxXY[1] - 0.0f;
        } else if (this.xyz != null) {
            this.boxXY[1] = this.boxXY[1] - (float)(this.ascent / 2);
        }
    }

    public static void setBoxXY(float f, float f2, float f3, float f4, float[] fArray, boolean bl) {
        float f5;
        if (f3 > 0.0f || bl) {
            f5 = f3;
        } else {
            f5 = -f;
            f5 = f3 == 0.0f ? (f5 /= 2.0f) : (f5 += f3);
        }
        float f6 = bl || f4 > 0.0f ? -f2 - f4 : (f4 == 0.0f ? -f2 / 2.0f : -f4);
        fArray[0] = fArray[0] + f5;
        fArray[1] = fArray[1] + f6;
        fArray[2] = f;
        fArray[3] = f2;
    }

    /*
     * Unable to fully structure code
     */
    private int stringWidth(String var1_1) {
        var2_2 = 0;
        var3_3 = 1;
        var4_4 = 1;
        if (var1_1 == null) {
            return 0;
        }
        if (var1_1.indexOf("<su") < 0 && var1_1.indexOf("<color") < 0) {
            return this.font.stringWidth(var1_1);
        }
        var5_5 = var1_1.length();
        var7_6 = 0;
        while (var7_6 < var5_5) {
            if (var1_1.charAt(var7_6) != '<') ** GOTO lbl-1000
            if (var7_6 + 8 <= var5_5 && (var1_1.substring(var7_6, var7_6 + 7).equals("<color ") || var1_1.substring(var7_6, var7_6 + 8).equals("</color>")) && (var8_8 = var1_1.indexOf(">", var7_6)) >= 0) {
                var7_6 = var8_8;
            } else if (var7_6 + 5 <= var5_5 && ((var6_7 = var1_1.substring(var7_6, var7_6 + 5)).equals("<sub>") || var6_7.equals("<sup>"))) {
                var7_6 += 4;
                var3_3 = var4_4;
            } else if (var7_6 + 6 <= var5_5 && ((var6_7 = var1_1.substring(var7_6, var7_6 + 6)).equals("</sub>") || var6_7.equals("</sup>"))) {
                var7_6 += 5;
                var3_3 = 1;
            } else lbl-1000:
            // 2 sources

            {
                var2_2 += this.font.stringWidth(var1_1.substring(var7_6, var7_6 + 1)) * var3_3;
            }
            ++var7_6;
        }
        return var2_2;
    }

    public void setXYA(float[] fArray, int n) {
        if (n == 0) {
            fArray[2] = this.boxX;
            switch (this.align) {
                case 8: {
                    fArray[2] = fArray[2] + this.boxWidth / 2.0f;
                    break;
                }
                case 12: {
                    fArray[2] = fArray[2] + (this.boxWidth - this.xAdj);
                    break;
                }
                default: {
                    fArray[2] = fArray[2] + this.xAdj;
                }
            }
            fArray[0] = fArray[2];
            fArray[1] = this.y0;
        }
        switch (this.align) {
            case 8: {
                fArray[0] = fArray[2] - (float)(this.widths[n] / 2);
                break;
            }
            case 12: {
                fArray[0] = fArray[2] - (float)this.widths[n];
            }
        }
        fArray[1] = fArray[1] + (float)this.lineHeight;
    }

    public void appendFontCmd(SB sB) {
        sB.append("  " + Shape.getFontCommand("echo", this.font));
        if (this.scalePixelsPerMicron > 0.0f) {
            sB.append(" " + 10000.0f / this.scalePixelsPerMicron);
        }
    }

    public void setScalePixelsPerMicron(float f) {
        this.fontScale = 0.0f;
        this.scalePixelsPerMicron = f;
    }

    public void setXYZ(P3 p3, boolean bl) {
        this.xyz = p3;
        if (p3 == null) {
            this.zSlab = Integer.MIN_VALUE;
        }
        if (bl) {
            this.valign = p3 == null ? 3 : 4;
            this.adjustForWindow = p3 == null;
        }
    }

    public void setTranslucent(float f, boolean bl) {
        if (bl) {
            if (this.bgcolix != 0) {
                this.bgcolix = C.getColixTranslucent3(this.bgcolix, !Float.isNaN(f), f);
            }
        } else {
            this.colix = C.getColixTranslucent3(this.colix, !Float.isNaN(f), f);
        }
    }

    public void setMovableX(int n) {
        this.valign = this.valign == 4 ? 4 : 3;
        this.movableX = n;
        this.movableXPercent = Integer.MAX_VALUE;
    }

    public void setMovableY(int n) {
        this.valign = this.valign == 4 ? 4 : 3;
        this.movableY = n;
        this.movableYPercent = Integer.MAX_VALUE;
    }

    public void setMovableXPercent(int n) {
        this.valign = this.valign == 4 ? 4 : 3;
        this.movableX = Integer.MAX_VALUE;
        this.movableXPercent = n;
    }

    public void setMovableYPercent(int n) {
        this.valign = this.valign == 4 ? 4 : 3;
        this.movableY = Integer.MAX_VALUE;
        this.movableYPercent = n;
    }

    public void setMovableZPercent(int n) {
        if (this.valign != 4) {
            this.valign = 3;
        }
        this.movableZ = Integer.MAX_VALUE;
        this.movableZPercent = n;
    }

    public void setZs(int n, int n2) {
        this.z = n;
        this.zSlab = n2;
    }

    public void setXYZs(int n, int n2, int n3, int n4) {
        this.setMovableX(n);
        this.setMovableY(n2);
        this.setZs(n3, n4);
    }

    public void setScript(String string) {
        this.script = string == null || string.length() == 0 ? null : string;
    }

    public boolean setAlignmentLCR(String string) {
        if ("left".equals(string)) {
            return this.setAlignment(4);
        }
        if ("center".equals(string)) {
            return this.setAlignment(8);
        }
        if ("right".equals(string)) {
            return this.setAlignment(12);
        }
        return false;
    }

    public boolean setAlignment(int n) {
        if (this.align != n) {
            this.align = n;
            this.recalc();
        }
        return true;
    }

    public void setBoxOffsetsInWindow(float f, float f2, float f3) {
        float f4 = this.boxX;
        float f5 = this.boxWidth + f;
        if (f4 + f5 > (float)this.windowWidth) {
            f4 = (float)this.windowWidth - f5;
        }
        if (f4 < f) {
            f4 = f;
        }
        this.boxX = f4;
        float f6 = f3;
        float f7 = this.boxHeight;
        if (f6 + f7 > (float)this.windowHeight) {
            f6 = (float)this.windowHeight - f7;
        }
        if (f6 < f2) {
            f6 = f2;
        }
        this.boxY = f6;
    }

    public void setWindow(int n, int n2, float f) {
        this.windowWidth = n;
        this.windowHeight = n2;
        if (this.pymolOffset == null && this.scalePixelsPerMicron < 0.0f && f != 0.0f) {
            this.setScalePixelsPerMicron(f);
        }
    }

    public boolean checkObjectClicked(boolean bl, int n, int n2, BS bS) {
        if (this.hidden || this.script == null || this.modelIndex >= 0 && !bS.get(this.modelIndex)) {
            return false;
        }
        if (bl) {
            n <<= 1;
            n2 <<= 1;
        }
        return (float)n >= this.boxX && (float)n <= this.boxX + this.boxWidth && (float)n2 >= this.boxY && (float)n2 <= this.boxY + this.boxHeight;
    }

    public void getPymolScreenOffset(P3 p3, P3i p3i, int n, P3 p32, float f) {
        float f2 = this.pymolOffset[0];
        if (p3 != null && Math.abs(f2) % 2.0f == 1.0f) {
            p32.setT(p3);
        } else {
            p32.set(0.0f, 0.0f, 0.0f);
        }
        p32.add3(this.pymolOffset[4], this.pymolOffset[5], this.pymolOffset[6]);
        this.vwr.tm.transformPtScr(p32, p3i);
        if (f2 == 2.0f || f2 == 3.0f) {
            p3i.x = (int)((float)p3i.x + this.pymolOffset[1]);
            p3i.y = (int)((float)p3i.y + this.pymolOffset[2]);
            p3i.z = (int)((float)p3i.z + this.pymolOffset[3]);
        }
        this.setXYZs(p3i.x, p3i.y, p3i.z, n);
        this.setScalePixelsPerMicron(f);
    }
}

