/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.Interface;
import org.jmol.atomdata.AtomData;
import org.jmol.jvxl.readers.SurfaceFileReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.quantum.NciCalculation;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

abstract class VolumeFileReader
extends SurfaceFileReader {
    protected boolean endOfData;
    protected boolean negativeAtomCount;
    protected int ac;
    protected int nSurfaces;
    protected boolean isAngstroms;
    protected boolean canDownsample;
    protected int[] downsampleRemainders;
    private boolean getNCIPlanes;
    protected int nData;
    protected boolean readerClosed;
    protected int downsampleFactor;
    protected int nSkipX;
    protected int nSkipY;
    protected int nSkipZ;
    private float[][] yzPlanesRaw;
    private int iPlaneNCI;
    protected P3[] boundingBox;
    private boolean isScaledAlready;

    VolumeFileReader() {
    }

    @Override
    void init2(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        this.init2VFR(surfaceGenerator, bufferedReader);
    }

    void init2VFR(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        this.init2SFR(surfaceGenerator, bufferedReader);
        this.isXLowToHigh = true;
        this.isProgressive = true;
        this.canDownsample = true;
        this.jvxlData.wasCubic = true;
        this.boundingBox = this.params.boundingBox;
        if (this.params.qmOrbitalType == 4) {
            this.hasColorData = this.params.parameters == null || this.params.parameters[1] >= 0.0f;
            this.getNCIPlanes = true;
            this.params.insideOut = !this.params.insideOut;
        }
    }

    protected float recordData(float f) {
        if (Float.isNaN(f)) {
            return f;
        }
        if (f < this.dataMin) {
            this.dataMin = f;
        }
        if (f > this.dataMax) {
            this.dataMax = f;
        }
        this.dataMean += f;
        ++this.nData;
        return f;
    }

    @Override
    protected void closeReader() {
        if (this.readerClosed) {
            return;
        }
        this.readerClosed = true;
        this.closeReaderSFR();
        if (this.nData == 0 || this.dataMax == -3.4028235E38f) {
            return;
        }
        this.dataMean /= (float)this.nData;
        Logger.info("VolumeFileReader closing file: " + this.nData + " points read \ndata min/max/mean = " + this.dataMin + "/" + this.dataMax + "/" + this.dataMean);
    }

    @Override
    protected boolean readVolumeParameters(boolean bl) {
        this.endOfData = false;
        this.nSurfaces = this.readVolumetricHeader();
        if (this.nSurfaces == 0) {
            return false;
        }
        if (this.nSurfaces < this.params.fileIndex) {
            Logger.warn("not enough surfaces in file -- resetting params.fileIndex to " + this.nSurfaces);
            this.params.fileIndex = this.nSurfaces;
        }
        return true;
    }

    @Override
    protected boolean readVolumeData(boolean bl) {
        return this.readVolumeDataVFR(bl);
    }

    protected boolean readVolumeDataVFR(boolean bl) {
        if (!this.gotoAndReadVoxelData(bl)) {
            return false;
        }
        if (!this.vertexDataOnly) {
            Logger.info("JVXL read: " + this.nPointsX + " x " + this.nPointsY + " x " + this.nPointsZ + " data points");
        }
        return true;
    }

    private int readVolumetricHeader() {
        block11: {
            this.readParameters();
            if (this.ac != Integer.MIN_VALUE) break block11;
            return 0;
        }
        try {
            int n;
            boolean bl;
            if (!this.vertexDataOnly) {
                Logger.info("voxel grid origin:" + this.volumetricOrigin);
            }
            int n2 = this.params.downsampleFactor;
            boolean bl2 = bl = this.canDownsample && n2 > 1;
            if (n2 > 1 && !this.canDownsample) {
                this.jvxlData.msg = String.valueOf(this.jvxlData.msg) + "\ncannot downsample this file type";
            }
            if (bl) {
                this.downsampleRemainders = new int[3];
                Logger.info("downsample factor = " + n2);
                n = 0;
                while (n < 3) {
                    int n3 = this.voxelCounts[n];
                    this.downsampleRemainders[n] = n3 % n2;
                    int n4 = n;
                    this.voxelCounts[n4] = this.voxelCounts[n4] / n2;
                    if (this.isPeriodic) {
                        int n5 = n;
                        this.voxelCounts[n5] = this.voxelCounts[n5] + 1;
                        int n6 = n;
                        this.downsampleRemainders[n6] = this.downsampleRemainders[n6] - 1;
                    }
                    this.volumetricVectors[n].scale(n2);
                    Logger.info("downsampling axis " + (n + 1) + " from " + n3 + " to " + this.voxelCounts[n]);
                    ++n;
                }
            }
            if (!this.vertexDataOnly) {
                n = 0;
                while (n < 3) {
                    if (!this.isAngstroms) {
                        this.volumetricVectors[n].scale(0.5291772f);
                    }
                    this.line = String.valueOf(this.voxelCounts[n]) + " " + this.volumetricVectors[n].x + " " + this.volumetricVectors[n].y + " " + this.volumetricVectors[n].z;
                    this.jvxlFileHeaderBuffer.append(this.line).appendC('\n');
                    Logger.info("voxel grid count/vector:" + this.line);
                    ++n;
                }
            }
            this.scaleIsosurface(this.params.scale);
            this.volumeData.setVolumetricXml();
            return this.nSurfaces;
        }
        catch (Exception exception) {
            Logger.error(exception.toString());
            return 0;
        }
    }

    protected abstract void readParameters() throws Exception;

    protected String skipComments(boolean bl) throws Exception {
        SB sB = new SB();
        while (this.rd() != null && (bl && this.line.length() == 0 || this.line.indexOf("#") == 0)) {
            sB.append(this.line).appendC('\n');
        }
        return sB.toString();
    }

    protected void readVoxelVector(int n) throws Exception {
        this.rd();
        V3 v3 = this.volumetricVectors[n];
        this.voxelCounts[n] = this.parseIntStr(this.line);
        if (this.voxelCounts[n] == Integer.MIN_VALUE) {
            this.next[0] = this.line.indexOf(" ");
        }
        v3.set(this.parseFloat(), this.parseFloat(), this.parseFloat());
        if (this.isAnisotropic) {
            this.setVectorAnisotropy(v3);
        }
    }

    void initializeSurfaceData() {
        this.downsampleFactor = this.params.downsampleFactor;
        this.nSkipX = 0;
        this.nSkipY = 0;
        this.nSkipZ = 0;
        if (this.canDownsample && this.downsampleFactor > 0) {
            this.nSkipX = this.downsampleFactor - 1;
            this.nSkipZ = (this.nPointsZ - (this.isPeriodic ? 1 : 0)) * this.downsampleFactor + this.downsampleRemainders[2];
            this.nSkipY = this.downsampleRemainders[2] + (this.downsampleFactor - 1) * this.nSkipZ;
            this.nSkipZ = this.downsampleRemainders[1] * this.nSkipZ + (this.downsampleFactor - 1) * this.nSkipZ * ((this.nPointsY - (this.isPeriodic ? 1 : 0)) * this.downsampleFactor + this.downsampleRemainders[1]);
        }
        if (this.params.thePlane != null) {
            this.params.cutoff = 0.0f;
        } else if (this.isJvxl) {
            this.params.cutoff = this.params.isBicolorMap || this.params.colorBySign ? 0.01f : 0.5f;
        }
        this.nDataPoints = 0;
        this.next[0] = 0;
        this.line = "";
        this.jvxlNSurfaceInts = 0;
    }

    @Override
    protected void readSurfaceData(boolean bl) throws Exception {
        this.readSurfaceDataVFR(bl);
    }

    protected void readSurfaceDataVFR(boolean bl) throws Exception {
        this.initializeSurfaceData();
        if (this.isProgressive && !bl || this.isJvxl) {
            this.nDataPoints = this.volumeData.setVoxelCounts(this.nPointsX, this.nPointsY, this.nPointsZ);
            this.voxelData = null;
            if (this.isJvxl) {
                this.jvxlVoxelBitSet = this.getVoxelBitSet(this.nDataPoints);
            }
        } else if (bl && this.volumeData.hasPlane()) {
            this.volumeData.setVoxelMap();
            float f = this.volumeData.getToPlaneParameter();
            int n = 0;
            while (n < this.nPointsX) {
                int n2 = 0;
                while (n2 < this.nPointsY) {
                    int n3 = 0;
                    while (n3 < this.nPointsZ) {
                        float f2 = this.recordData(this.getNextVoxelValue());
                        if (this.volumeData.isNearPlane(n, n2, n3, f)) {
                            this.volumeData.setVoxelMapValue(n, n2, n3, f2);
                        }
                        if (this.nSkipX != 0) {
                            this.skipVoxels(this.nSkipX);
                        }
                        ++n3;
                    }
                    if (this.nSkipY != 0) {
                        this.skipVoxels(this.nSkipY);
                    }
                    ++n2;
                }
                if (this.nSkipZ != 0) {
                    this.skipVoxels(this.nSkipZ);
                }
                ++n;
            }
        } else {
            this.voxelData = AU.newFloat3(this.nPointsX, -1);
            int n = 0;
            while (n < this.nPointsX) {
                float[][] fArray = AU.newFloat2(this.nPointsY);
                this.voxelData[n] = fArray;
                int n4 = 0;
                while (n4 < this.nPointsY) {
                    float[] fArray2 = new float[this.nPointsZ];
                    fArray[n4] = fArray2;
                    int n5 = 0;
                    while (n5 < this.nPointsZ) {
                        fArray2[n5] = this.recordData(this.getNextVoxelValue());
                        if (this.nSkipX != 0) {
                            this.skipVoxels(this.nSkipX);
                        }
                        ++n5;
                    }
                    if (this.nSkipY != 0) {
                        this.skipVoxels(this.nSkipY);
                    }
                    ++n4;
                }
                if (this.nSkipZ != 0) {
                    this.skipVoxels(this.nSkipZ);
                }
                ++n;
            }
        }
        this.volumeData.setVoxelDataAsArray(this.voxelData);
    }

    @Override
    public float[] getPlane(int n) {
        if (n == 0) {
            this.initPlanes();
        }
        if (this.getNCIPlanes) {
            return this.getPlaneNCI(n);
        }
        float[] fArray = this.getPlaneSR(n);
        if (this.qpc == null) {
            this.getPlaneVFR(fArray, true);
        }
        return fArray;
    }

    public float[] getPlaneNCI(int n) {
        float[] fArray;
        if (this.iPlaneNCI == 0) {
            this.qpc = (NciCalculation)Interface.getOption("quantum.NciCalculation", (Viewer)this.sg.atomDataServer, null);
            AtomData atomData = new AtomData();
            atomData.modelIndex = -1;
            atomData.bsSelected = this.params.bsSelected;
            this.sg.fillAtomData(atomData, 1);
            ((NciCalculation)this.qpc).setupCalculation(this.volumeData, this.sg.params.bsSelected, null, null, atomData.atoms, -1, true, null, this.params.parameters, this.params.testFlags);
            this.iPlaneNCI = 1;
            this.yzPlanesRaw = new float[4][this.yzCount];
            this.qpc.setPlanes(this.yzPlanesRaw);
            if (this.hasColorData) {
                this.getPlaneVFR(this.yzPlanesRaw[0], false);
                this.getPlaneVFR(this.yzPlanesRaw[1], false);
                float[] fArray2 = this.yzPlanes[0];
                int n2 = 0;
                while (n2 < this.yzCount) {
                    fArray2[n2] = Float.NaN;
                    ++n2;
                }
                return fArray2;
            }
            this.iPlaneNCI = -1;
        }
        float f = this.qpc.getNoValue();
        int n3 = this.nPointsX - 1;
        switch (this.iPlaneNCI) {
            case -1: {
                fArray = this.yzPlanes[n % 2];
                ++n3;
                break;
            }
            case 3: {
                fArray = this.yzPlanesRaw[0];
                this.yzPlanesRaw[0] = this.yzPlanesRaw[1];
                this.yzPlanesRaw[1] = this.yzPlanesRaw[2];
                this.yzPlanesRaw[2] = this.yzPlanesRaw[3];
                this.yzPlanesRaw[3] = fArray;
                fArray = this.yzPlanesRaw[this.iPlaneNCI];
                break;
            }
            default: {
                ++this.iPlaneNCI;
                fArray = this.yzPlanesRaw[this.iPlaneNCI];
            }
        }
        if (n < n3) {
            this.getPlaneVFR(fArray, false);
            fArray = this.yzPlanes[n % 2];
            this.qpc.calcPlane(n, fArray);
            int n4 = 0;
            while (n4 < this.yzCount) {
                if (fArray[n4] != f) {
                    this.recordData(fArray[n4]);
                }
                ++n4;
            }
        } else {
            int n5 = 0;
            while (n5 < this.yzCount) {
                fArray[n5] = Float.NaN;
                ++n5;
            }
        }
        return fArray;
    }

    private void getPlaneVFR(float[] fArray, boolean bl) {
        try {
            int n = 0;
            int n2 = 0;
            while (n < this.nPointsY) {
                int n3 = 0;
                while (n3 < this.nPointsZ) {
                    float f = this.getNextVoxelValue();
                    if (bl) {
                        this.recordData(f);
                    }
                    fArray[n2++] = f;
                    if (this.nSkipX != 0) {
                        this.skipVoxels(this.nSkipX);
                    }
                    ++n3;
                }
                if (this.nSkipY != 0) {
                    this.skipVoxels(this.nSkipY);
                }
                ++n;
            }
            if (this.nSkipZ != 0) {
                this.skipVoxels(this.nSkipZ);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public float getValue(int n, int n2, int n3, int n4) {
        if (this.boundingBox != null) {
            this.volumeData.voxelPtToXYZ(n, n2, n3, this.ptTemp);
            if (this.ptTemp.x < this.boundingBox[0].x || this.ptTemp.x > this.boundingBox[1].x || this.ptTemp.y < this.boundingBox[0].y || this.ptTemp.y > this.boundingBox[1].y || this.ptTemp.z < this.boundingBox[0].z || this.ptTemp.z > this.boundingBox[1].z) {
                return Float.NaN;
            }
        }
        return this.getValue2(n, n2, n3, n4);
    }

    private void skipVoxels(int n) throws Exception {
        int n2 = n;
        while (--n2 >= 0) {
            this.getNextVoxelValue();
        }
    }

    protected BS getVoxelBitSet(int n) throws Exception {
        return null;
    }

    protected float getNextVoxelValue() throws Exception {
        float f = 0.0f;
        if (this.nSurfaces > 1 && !this.params.blockCubeData) {
            int n = 1;
            while (n < this.params.fileIndex) {
                this.nextVoxel();
                ++n;
            }
            f = this.nextVoxel();
            n = this.params.fileIndex;
            while (n < this.nSurfaces) {
                this.nextVoxel();
                ++n;
            }
        } else {
            f = this.nextVoxel();
        }
        return f;
    }

    protected float nextVoxel() throws Exception {
        float f = this.parseFloat();
        if (Float.isNaN(f)) {
            while (this.rd() != null && Float.isNaN(f = this.parseFloatStr(this.line))) {
            }
            if (this.line == null) {
                if (!this.endOfData) {
                    Logger.warn("end of file reading cube voxel data? nBytes=" + this.nBytes + " nDataPoints=" + this.nDataPoints + " (line):" + this.line);
                }
                this.endOfData = true;
                this.line = "0 0 0 0 0 0 0 0 0 0";
            }
        }
        return f;
    }

    @Override
    protected void gotoData(int n, int n2) throws Exception {
        if (!this.params.blockCubeData) {
            return;
        }
        if (n > 0) {
            Logger.info("skipping " + n + " data sets, " + n2 + " points each");
        }
        int n3 = 0;
        while (n3 < n) {
            this.skipData(n2);
            ++n3;
        }
    }

    protected void skipData(int n) throws Exception {
        this.skipDataVFR(n);
    }

    protected void skipDataVFR(int n) throws Exception {
        int n2 = 0;
        while (n2 < n) {
            n2 += this.countData(this.rd());
        }
    }

    /*
     * Unable to fully structure code
     */
    private int countData(String var1_1) {
        var2_2 = 0;
        var3_3 = 0;
        var4_4 = var1_1.length();
        ** GOTO lbl13
        {
            ++var3_3;
            do {
                if (var3_3 < var4_4 && ((var5_5 = var1_1.charAt(var3_3)) == ' ' || var5_5 == '\t')) continue block0;
                if (var3_3 < var4_4) {
                    ++var2_2;
                }
                while (var3_3 < var4_4 && (var5_5 = var1_1.charAt(var3_3)) != ' ' && var5_5 != '\t') {
                    ++var3_3;
                }
lbl13:
                // 2 sources

            } while (var3_3 < var4_4);
        }
        return var2_2;
    }

    protected static boolean checkAtomLine(boolean bl, boolean bl2, String string, String string2, SB sB) {
        if (string2.indexOf("ANGSTROMS") >= 0) {
            bl2 = true;
        }
        int n = string == null ? Integer.MAX_VALUE : PT.parseInt(string);
        switch (n) {
            case -2147483648: {
                n = 0;
                string2 = " " + string2.substring(string2.indexOf(" ") + 1);
                break;
            }
            case 0x7FFFFFFF: {
                n = Integer.MIN_VALUE;
                break;
            }
            default: {
                String string3 = "" + n;
                string2 = string2.substring(string2.indexOf(string3) + string3.length());
            }
        }
        if (bl2) {
            if (string2.indexOf("ANGSTROM") < 0) {
                string2 = String.valueOf(string2) + " ANGSTROMS";
            }
        } else if (string2.indexOf("BOHR") < 0) {
            string2 = String.valueOf(string2) + " BOHR";
        }
        string2 = String.valueOf(n == Integer.MIN_VALUE ? "" : String.valueOf(bl ? "+" : "-") + Math.abs(n)) + string2 + "\n";
        sB.append(string2);
        return bl2;
    }

    @Override
    protected float getSurfacePointAndFraction(float f, boolean bl, float f2, float f3, T3 t3, V3 v3, int n, int n2, int n3, int n4, int n5, float[] fArray, T3 t32) {
        return this.getSPFv(f, bl, f2, f3, t3, v3, n, n2, n3, n4, n5, fArray, t32);
    }

    protected float getSPFv(float f, boolean bl, float f2, float f3, T3 t3, V3 v3, int n, int n2, int n3, int n4, int n5, float[] fArray, T3 t32) {
        float f4 = this.getSPF(f, bl, f2, f3, t3, v3, n, n2, n3, n4, n5, fArray, t32);
        if (this.qpc == null || Float.isNaN(f4) || !this.hasColorData) {
            return f4;
        }
        n4 = this.marchingCubes.getLinearOffset(n, n2, n3, n4);
        n5 = this.marchingCubes.getLinearOffset(n, n2, n3, n5);
        return this.qpc.process(n4, n5, fArray[0]);
    }

    private void scaleIsosurface(float f) {
        if (this.isScaledAlready) {
            return;
        }
        this.isScaledAlready = true;
        if (this.isAnisotropic) {
            this.setVolumetricAnisotropy();
        }
        if (Float.isNaN(f)) {
            return;
        }
        Logger.info("applying scaling factor of " + f);
        this.volumetricOrigin.scaleAdd2((1.0f - f) / 2.0f, this.volumetricVectors[0], this.volumetricOrigin);
        this.volumetricOrigin.scaleAdd2((1.0f - f) / 2.0f, this.volumetricVectors[1], this.volumetricOrigin);
        this.volumetricOrigin.scaleAdd2((1.0f - f) / 2.0f, this.volumetricVectors[2], this.volumetricOrigin);
        this.volumetricVectors[0].scale(f);
        this.volumetricVectors[1].scale(f);
        this.volumetricVectors[2].scale(f);
    }

    protected void swapXZ() {
        V3 v3 = this.volumetricVectors[0];
        this.volumetricVectors[0] = this.volumetricVectors[2];
        this.volumetricVectors[2] = v3;
        int n = this.voxelCounts[0];
        this.voxelCounts[0] = this.voxelCounts[2];
        this.voxelCounts[2] = n;
        this.params.insideOut = !this.params.insideOut;
    }
}

