/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.adapter.readers.quantum.MOReader;
import org.jmol.adapter.readers.xml.XmlCmlReader;
import org.jmol.adapter.readers.xml.XmlReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.Resolver;
import org.jmol.quantum.QS;
import org.jmol.util.Logger;

public abstract class XmlMOReader
extends XmlCmlReader {
    private MOReader moReader;
    private boolean skipMOs;
    private Map<String, int[]> htSlaterIDs;
    private Lst<float[]> basisData;
    private String basisId;
    private boolean isSpherical;
    private int minL;
    private int maxL;
    private String[] basisIds;
    private String[] basisAtoms;
    private float orbOcc;
    private float orbEnergy;
    private int gaussianCount;
    private int slaterCount;
    private int coefCount;
    private int groupCount;
    private Lst<Lst<float[]>> lstGaussians;
    private int moCount;
    private String calcType;
    private int iModelMO;
    protected String dclist;
    protected String dslist;
    protected String fclist;
    protected String fslist;
    protected boolean iHaveCoefMaps;
    private int maxContraction;

    @Override
    protected void processXml(XmlReader xmlReader, Object object) throws Exception {
        this.htModelAtomMap = new Hashtable();
        this.processXml2(xmlReader, object);
    }

    protected boolean processStartMO(String string) {
        if (!this.parent.doReadMolecularOrbitals) {
            return false;
        }
        if (string.equals("molecule")) {
            String string2 = (String)this.atts.get("method");
            if (string2 != null) {
                this.calcType = String.valueOf(string2) + "(" + (String)this.atts.get("basis") + ")";
            }
            return true;
        }
        if (string.equals("basisset")) {
            this.iModelMO = this.asc.iSet;
            this.lstGaussians = new Lst();
            this.htSlaterIDs = new Hashtable<String, int[]>();
            this.slaterCount = 0;
            this.gaussianCount = 0;
            this.groupCount = 0;
            this.coefCount = 0;
            if (this.moReader == null && !this.skipMOs) {
                Object object = Resolver.getReader("MO", this.parent.htParams);
                if (object instanceof String) {
                    this.skipMOs = true;
                } else {
                    this.moReader = (MOReader)object;
                    this.moReader.asc = this.asc;
                    if (this.iHaveCoefMaps) {
                        int[][] nArray = this.moReader.getDfCoefMaps();
                        if (this.dclist != null) {
                            QS.createDFMap(nArray[4], this.dclist, "DXX   DYY   DZZ   DXY   DXZ   DYZ", 2);
                        }
                        if (this.dslist != null) {
                            QS.createDFMap(nArray[3], this.dslist, "d0    d1+   d1-   d2+   d2-", 2);
                        }
                        if (this.fclist != null) {
                            QS.createDFMap(nArray[6], this.fclist, "XXX   YYY   ZZZ   XYY   XXY   XXZ   XZZ   YZZ   YYZ   XYZ", 2);
                        }
                        if (this.fslist != null) {
                            QS.createDFMap(nArray[5], this.fslist, "f0    f1+   f1-   f2+   f2-   f3+   f3-", 2);
                        }
                    }
                }
            }
            if (this.moReader != null) {
                this.moReader.calculationType = this.calcType;
            }
            return true;
        }
        if (this.moReader != null) {
            if (string.equals("basisgroup")) {
                ++this.groupCount;
                this.basisId = (String)this.atts.get("id");
                this.isSpherical = "spherical".equalsIgnoreCase((String)this.atts.get("angular"));
                this.minL = PT.parseInt((String)this.atts.get("minl"));
                this.maxL = PT.parseInt((String)this.atts.get("maxl"));
                int n = PT.parseInt((String)this.atts.get("contractions"));
                int n2 = n * (this.isSpherical ? this.minL * 2 + 1 : this.minL * (this.minL + 3) / 2 + 1);
                this.htModelAtomMap.put(String.valueOf(this.basisId) + "_count", n2);
                return true;
            }
            if (string.equals("basisexponents") || string.equals("basiscontraction")) {
                this.setKeepChars(true);
                return true;
            }
            if (string.equals("orbital") && this.gaussianCount > 0) {
                this.orbOcc = PT.parseFloat((String)this.atts.get("occupation"));
                this.orbEnergy = PT.parseFloat((String)this.atts.get("energy"));
                this.setKeepChars(true);
                return true;
            }
        }
        return false;
    }

    protected boolean processEndMO(String string) {
        if (this.moReader != null) {
            if (string.equals("basisexponents")) {
                this.basisData = new Lst();
                this.basisData.addLast(PT.parseFloatArray(this.chars.toString()));
                this.setKeepChars(false);
                return true;
            }
            if (string.equals("basiscontraction")) {
                float[] fArray = PT.parseFloatArray(this.chars.toString());
                this.basisData.addLast(fArray);
                if (this.basisData.size() > this.maxContraction) {
                    this.maxContraction = this.basisData.size();
                }
                this.setKeepChars(false);
                return true;
            }
            if (string.equals("basisgroup")) {
                String string2;
                switch (this.minL) {
                    case 0: {
                        string2 = this.maxL == 1 ? "L" : "S";
                        break;
                    }
                    case 1: {
                        string2 = "P";
                        break;
                    }
                    default: {
                        String string3 = string2 = this.minL <= 7 ? "SPDFGHI".substring(this.minL, this.minL + 1) : "?";
                        if (!this.isSpherical) break;
                        string2 = String.valueOf(2 * this.minL + 1) + string2;
                    }
                }
                this.lstGaussians.addLast(this.basisData);
                int n = ((float[])this.basisData.get(0)).length;
                int n2 = 1;
                int n3 = this.basisData.size();
                while (n2 < n3) {
                    this.htSlaterIDs.put(String.valueOf(this.basisId) + "_" + n2, new int[]{-1, MOReader.getQuantumShellTagID(string2), this.gaussianCount + 1, n});
                    this.gaussianCount += n;
                    ++n2;
                }
                return true;
            }
            if (string.equals("basisset")) {
                this.buildSlaters();
                return true;
            }
            if (string.equals("orbital")) {
                if (this.gaussianCount == 0) {
                    return true;
                }
                float[] fArray = PT.parseFloatArray(this.chars.toString());
                if (this.moCount == 0) {
                    if (fArray.length != this.coefCount) {
                        Logger.error("Number of orbital coefficients (" + fArray.length + ") does not agree with expected number (" + this.coefCount + ")");
                        this.moReader = null;
                        this.skipMOs = true;
                        return true;
                    }
                    Logger.info(String.valueOf(this.coefCount) + " coefficients found");
                }
                this.moReader.addCoef(new Hashtable<String, Object>(), fArray, null, this.orbEnergy, this.orbOcc, this.moCount++);
                this.setKeepChars(false);
                return true;
            }
            if (string.equals("orbitals")) {
                this.moReader.setMOData(true);
                Logger.info("XmlMOReader created\n " + this.gaussianCount + " gaussians\n " + this.slaterCount + " slaters\n " + this.groupCount + " groups\n " + this.coefCount + " orbital coefficients\n " + this.moCount + " orbitals");
                return true;
            }
            if (this.state == 19) {
                if (string.equals("bases")) {
                    this.basisIds = this.getXlink((String)this.atts.get("href"), "basisGroup", false);
                } else if (string.equals("atoms")) {
                    this.basisAtoms = this.getXlink((String)this.atts.get("href"), "atom", true);
                } else if (string.equals("association")) {
                    this.state = 6;
                    int n = this.basisAtoms.length;
                    while (--n >= 0) {
                        Atom atom = (Atom)this.htModelAtomMap.get(this.basisAtoms[n]);
                        if (atom == null) {
                            Logger.error("XmlMOReader atom not found; orbitals skipped: " + atom);
                            this.moReader = null;
                            this.skipMOs = true;
                            return true;
                        }
                        this.htModelAtomMap.put(String.valueOf(this.basisAtoms[n]) + "_basis", this.basisIds);
                    }
                    this.slaterCount += this.basisIds.length * this.basisAtoms.length;
                }
                return true;
            }
        }
        return false;
    }

    private void buildSlaters() {
        int n;
        float[][] fArray = AU.newFloat2(this.gaussianCount);
        int n2 = 0;
        int n3 = 0;
        int n4 = this.lstGaussians.size();
        while (n2 < n4) {
            this.basisData = (Lst)this.lstGaussians.get(n2);
            float[] fArray2 = (float[])this.basisData.get(0);
            n = 1;
            int n5 = this.basisData.size();
            while (n < n5) {
                float[] fArray3 = (float[])this.basisData.get(n);
                int n6 = 0;
                while (n6 < fArray2.length) {
                    fArray[n3++] = new float[]{fArray2[n6], fArray3[n6], 0.0f};
                    ++n6;
                }
                ++n;
            }
            ++n2;
        }
        this.moReader.gaussians = fArray;
        Lst<int[]> lst = new Lst<int[]>();
        String string = (String)this.htModelAtomMap.get("" + this.iModelMO);
        n4 = this.asc.getAtomSetAtomIndex(this.iModelMO);
        int n7 = 0;
        n = this.asc.getAtomSetAtomCount(this.iModelMO);
        while (n7 < n) {
            String[] stringArray = (String[])this.htModelAtomMap.get(String.valueOf(string) + this.asc.atoms[n4 + n7].atomName + "_basis");
            if (stringArray != null) {
                int n8 = 0;
                while (n8 < stringArray.length) {
                    String string2 = String.valueOf(stringArray[n8]) + "_count";
                    this.coefCount += ((Integer)this.htModelAtomMap.get(string2)).intValue();
                    int n9 = 1;
                    while (n9 < this.maxContraction) {
                        int[] nArray = this.htSlaterIDs.get(String.valueOf(stringArray[n8]) + "_" + n9);
                        if (nArray == null) break;
                        nArray = AU.arrayCopyI(nArray, -1);
                        this.moReader.shells = lst;
                        nArray[0] = n7 + 1;
                        lst.addLast(nArray);
                        ++n9;
                    }
                    ++n8;
                }
            }
            ++n7;
        }
    }

    private String[] getXlink(String string, String string2, boolean bl) {
        int n = string.indexOf(String.valueOf(string2) + "[") + 1;
        String[] stringArray = PT.split(string.substring(n), "'");
        String[] stringArray2 = new String[stringArray.length / 2];
        String string3 = bl ? PT.getQuotedAttribute(string.substring(0, n).replace('\'', '\"'), "molecule[@id") : "";
        int n2 = 1;
        int n3 = 0;
        while (n2 < stringArray.length) {
            stringArray2[n3++] = String.valueOf(string3) + stringArray[n2];
            n2 += 2;
        }
        return stringArray2;
    }
}

