/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import org.jmol.symmetry.CIPChirality;
import org.jmol.symmetry.CIPData;
import org.jmol.viewer.JC;

public class CIPDataTracker
extends CIPData {
    public Map<String, CIPTracker> htTracker = new Hashtable<String, CIPTracker>();
    private int lastIndex = -1;
    private Map<String, Object> lastInfo;

    @Override
    protected boolean isTracker() {
        return true;
    }

    @Override
    void track(CIPChirality cIPChirality, CIPChirality.CIPAtom cIPAtom, CIPChirality.CIPAtom cIPAtom2, int n, int n2, boolean bl) {
        CIPChirality.CIPAtom cIPAtom3;
        CIPChirality.CIPAtom cIPAtom4;
        if (cIPAtom == null || cIPAtom2 == null || cIPAtom.rootSubstituent == cIPAtom2.rootSubstituent) {
            return;
        }
        if (n2 > 0) {
            cIPAtom4 = cIPAtom2;
            cIPAtom3 = cIPAtom;
        } else {
            cIPAtom4 = cIPAtom;
            cIPAtom3 = cIPAtom2;
        }
        CIPTracker cIPTracker = new CIPTracker(cIPChirality.currentRule, cIPAtom4, cIPAtom3, n, Math.abs(n2), bl);
        this.htTracker.put(CIPDataTracker.getTrackerKey(cIPChirality.root, cIPAtom4, cIPAtom3), cIPTracker);
    }

    @Override
    String getRootTrackerResult(CIPChirality.CIPAtom cIPAtom) {
        String string = "";
        int n = 0;
        while (n < 3) {
            string = String.valueOf(string) + "\t" + cIPAtom.atoms[n] + "\t--------------\n";
            CIPTracker cIPTracker = this.htTracker.get(CIPDataTracker.getTrackerKey(cIPAtom, cIPAtom.atoms[n], cIPAtom.atoms[n + 1]));
            if (cIPTracker != null) {
                int n2 = Math.max(cIPTracker.bsa.length(), cIPTracker.bsb.length());
                string = String.valueOf(string) + cIPTracker.getTrackerLine(cIPTracker.a, cIPTracker.bsa, cIPTracker.rule == 8 ? cIPTracker.a.listRS[2] : null, n2);
                string = String.valueOf(string) + "\t   " + JC.getCIPRuleName(cIPTracker.rule) + "\n";
                string = String.valueOf(string) + cIPTracker.getTrackerLine(cIPTracker.b, cIPTracker.bsb, cIPTracker.rule == 8 ? cIPTracker.b.listRS[2] : null, n2);
            }
            ++n;
        }
        string = String.valueOf(string) + "\t" + cIPAtom.atoms[3] + "\t--------------\n";
        System.out.println(cIPAtom + "\n\n" + string);
        this.setCIPInfo(string, cIPAtom.atom.getIndex(), cIPAtom.atom.getAtomName());
        return string;
    }

    private void setCIPInfo(String string, int n, String string2) {
        Map<String, Object> map = this.getModelAuxiliaryInfoForAtom(n);
        if (map != null) {
            Hashtable<String, String> hashtable = (Hashtable<String, String>)map.get("CIPInfo");
            if (hashtable == null) {
                hashtable = new Hashtable<String, String>();
                map.put("CIPInfo", hashtable);
            }
            hashtable.put(string2, string);
        }
    }

    private Map<String, Object> getModelAuxiliaryInfoForAtom(int n) {
        Map<String, Object> map;
        if (n == this.lastIndex) {
            map = this.lastInfo;
        } else {
            this.lastIndex = n;
            map = this.lastInfo = this.vwr.ms.getModelAuxiliaryInfo(this.vwr.ms.at[this.lastIndex].getModelIndex());
        }
        return map;
    }

    private static String getTrackerKey(CIPChirality.CIPAtom cIPAtom, CIPChirality.CIPAtom cIPAtom2, CIPChirality.CIPAtom cIPAtom3) {
        return cIPAtom3.rootSubstituent == null ? "" : String.valueOf(cIPAtom.atom.getAtomName()) + "." + cIPAtom2.rootSubstituent.atom.getAtomName() + "-" + cIPAtom3.rootSubstituent.atom.getAtomName();
    }

    class CIPTracker {
        CIPChirality.CIPAtom a;
        CIPChirality.CIPAtom b;
        int sphere;
        int score;
        int rule;
        public BS bsa;
        public BS bsb;
        private boolean trackTerminal;

        CIPTracker(int n, CIPChirality.CIPAtom cIPAtom, CIPChirality.CIPAtom cIPAtom2, int n2, int n3, boolean bl) {
            this.rule = n;
            this.a = cIPAtom;
            this.b = cIPAtom2;
            this.sphere = n2;
            this.score = n3;
            this.trackTerminal = bl;
            this.bsa = cIPAtom.listRS == null ? new BS() : cIPAtom.listRS[0];
            this.bsb = cIPAtom2.listRS == null ? new BS() : cIPAtom2.listRS[0];
        }

        String getTrackerLine(CIPChirality.CIPAtom cIPAtom, BS bS, BS bS2, int n) {
            return "\t\t" + cIPAtom.myPath + (!this.trackTerminal ? "" : (cIPAtom.isTerminal ? "-o" : "-" + cIPAtom.atoms[0].atom.getAtomName())) + (this.rule != 8 && bS.length() == 0 ? "" : "\t" + this.getLikeUnlike(bS, cIPAtom.listRS, n) + (bS2 == null ? "" : "  " + this.getLikeUnlike(bS2, cIPAtom.listRS, -n))) + "\n";
        }

        private String getLikeUnlike(BS bS, BS[] bSArray, int n) {
            if (this.rule != 8 && this.rule != 6) {
                return "";
            }
            String string = n > 0 && (this.rule == 8 || bS == bSArray[1]) ? "(R)" : "(S)";
            n = Math.abs(n);
            int n2 = 0;
            while (n2 < n) {
                string = String.valueOf(string) + (bS.get(n2) ? "l" : "u");
                ++n2;
            }
            return string;
        }
    }
}

