/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import org.jmol.g3d.Graphics3D;
import org.jmol.g3d.Pixelator;

class PixelatorShaded
extends Pixelator {
    private int[] bgRGB;
    private int[] tmp = new int[3];
    private int zSlab;
    private int zDepth;
    int zShadePower;

    PixelatorShaded(Graphics3D graphics3D) {
        super(graphics3D);
    }

    Pixelator set(int n, int n2, int n3) {
        this.bgcolor = this.g.bgcolor;
        this.bgRGB = new int[]{this.bgcolor & 0xFF, this.bgcolor >> 8 & 0xFF, this.g.bgcolor >> 16 & 0xFF};
        this.zSlab = n < 0 ? 0 : n;
        this.zDepth = n2 < 0 ? 0 : n2;
        this.zShadePower = n3;
        this.p0 = this.g.pixel0;
        return this;
    }

    @Override
    void addPixel(int n, int n2, int n3) {
        if (n2 > this.zDepth) {
            return;
        }
        if (n2 >= this.zSlab && this.zShadePower > 0) {
            int n4;
            int[] nArray = this.tmp;
            int[] nArray2 = this.bgRGB;
            nArray[0] = n3;
            nArray[1] = n3 >> 8;
            nArray[2] = n3 >> 16;
            float f = (float)(this.zDepth - n2) / (float)(this.zDepth - this.zSlab);
            if (this.zShadePower > 1) {
                n4 = 0;
                while (n4 < this.zShadePower) {
                    f *= f;
                    ++n4;
                }
            }
            n4 = 0;
            while (n4 < 3) {
                nArray[n4] = nArray2[n4] + (int)(f * (float)((nArray[n4] & 0xFF) - nArray2[n4]));
                ++n4;
            }
            n3 = nArray[2] << 16 | nArray[1] << 8 | nArray[0] | n3 & 0xFF000000;
        }
        this.p0.addPixel(n, n2, n3);
    }

    void showZBuffer() {
        int n = this.p0.zb.length;
        while (--n >= 0) {
            if (this.p0.pb[n] == 0) continue;
            int n2 = (int)Math.min(255.0f, Math.max(0.0f, 255.0f * (float)(this.zDepth - this.p0.zb[n]) / (float)(this.zDepth - this.zSlab)));
            this.p0.pb[n] = 0xFF000000 | n2 | n2 << 8 | n2 << 16;
        }
    }
}

