/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import org.jmol.g3d.Graphics3D;

class Pixelator {
    protected final Graphics3D g;
    Pixelator p0;
    protected int[] zb;
    protected int[] pb;
    int width;
    int bgcolor;

    Pixelator(Graphics3D graphics3D) {
        this.g = graphics3D;
        this.bgcolor = this.g.bgcolor;
        this.setBuf();
    }

    void setBuf() {
        this.zb = this.g.zbuf;
        this.pb = this.g.pbuf;
    }

    void clearPixel(int n, int n2) {
        if (this.zb[n] > n2) {
            this.zb[n] = Integer.MAX_VALUE;
        }
    }

    void addPixel(int n, int n2, int n3) {
        this.zb[n] = n2;
        this.pb[n] = n3;
    }

    public void addImagePixel(byte by, int n, int n2, int n3, int n4, int n5) {
        if (n3 < this.zb[n2]) {
            switch (by) {
                case 0: {
                    return;
                }
                case 8: {
                    this.addPixel(n2, n3, n4);
                    return;
                }
            }
            by = (byte)(by + n);
            if (by <= 7) {
                int n6 = this.pb[n2];
                if (n5 != 0) {
                    n6 = Graphics3D.mergeBufferPixel(n6, n5, n5);
                }
                n6 = Graphics3D.mergeBufferPixel(n6, n4 & 0xFFFFFF | by << 24, this.bgcolor);
                this.addPixel(n2, n3, n6);
            }
        }
    }
}

