/*
 * Decompiled with CFR 0.152.
 */
package jspecview.java;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.List;
import javajs.awt.PlatformViewer;
import javajs.util.PT;
import org.jmol.util.Logger;

public class FileDropperJmol
implements DropTargetListener {
    private String fd_oldFileName = "";
    private PropertyChangeSupport fd_propSupport = new PropertyChangeSupport(this);
    public static final String FD_PROPERTY_INLINE = "inline";
    PropertyChangeListener pcl = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            FileDropperJmol.this.doDrop(propertyChangeEvent);
        }
    };

    public FileDropperJmol(PlatformViewer platformViewer) {
        this.addPropertyChangeListener(this.pcl);
    }

    public void dispose() {
        this.removePropertyChangeListener(this.pcl);
    }

    private void loadFile(String string) {
        if ((string = string.replace('\\', '/').trim()).indexOf("://") < 0) {
            string = String.valueOf(string.startsWith("/") ? "file://" : "file:///") + string;
        }
    }

    private void loadFiles(List<File> list) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < list.size()) {
            File file = list.get(n);
            String string = file.getAbsolutePath();
            string = String.valueOf((string = string.replace('\\', '/').trim()).startsWith("/") ? "file://" : "file:///") + string;
            stringBuilder.append("load ").append(n == 0 ? "" : "APPEND ").append(PT.esc(string)).append(";\n");
            ++n;
        }
        stringBuilder.append("frame *;reset;");
    }

    protected void doDrop(PropertyChangeEvent propertyChangeEvent) {
        propertyChangeEvent.getPropertyName();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fd_propSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fd_propSupport.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (Logger.debugging) {
            Logger.debug("DropOver detected...");
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (Logger.debugging) {
            Logger.debug("DropEnter detected...");
        }
        dropTargetDragEvent.acceptDrag(3);
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        if (Logger.debugging) {
            Logger.debug("DropExit detected...");
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        Object object;
        Object object2;
        if (Logger.debugging) {
            Logger.debug("Drop detected...");
        }
        Transferable transferable = dropTargetDropEvent.getTransferable();
        boolean bl = false;
        if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            object2 = null;
            try {
                dropTargetDropEvent.acceptDrop(3);
                object2 = transferable.getTransferData(DataFlavor.javaFileListFlavor);
                bl = true;
            }
            catch (Exception exception) {
                Logger.error("transfer failed");
            }
            if (object2 instanceof List) {
                List list = (List)object2;
                int n = list.size();
                if (n == 1) {
                    object = ((File)list.get(0)).getAbsolutePath().trim();
                    if (!((String)object).endsWith(".bmp")) {
                        dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                        this.loadFile((String)object);
                        return;
                    }
                } else {
                    dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                    this.loadFiles(list);
                    return;
                }
            }
        }
        if (Logger.debugging) {
            Logger.debug("browsing supported flavours to find something useful...");
        }
        if ((object2 = transferable.getTransferDataFlavors()) == null || ((DataFlavor[])object2).length == 0) {
            return;
        }
        int n = 0;
        while (n < ((DataFlavor[])object2).length) {
            DataFlavor dataFlavor = object2[n];
            object = null;
            Logger.info("df " + n + " flavor " + dataFlavor);
            Logger.info("  class: " + dataFlavor.getRepresentationClass().getName());
            Logger.info("  mime : " + dataFlavor.getMimeType());
            if (dataFlavor.getMimeType().startsWith("text/uri-list") && dataFlavor.getRepresentationClass().getName().equals("java.lang.String")) {
                try {
                    if (!bl) {
                        dropTargetDropEvent.acceptDrop(3);
                    }
                    bl = true;
                    object = transferable.getTransferData(dataFlavor);
                }
                catch (Exception exception) {
                    Logger.errorEx(null, exception);
                }
                if (object instanceof String) {
                    if (Logger.debugging) {
                        Logger.debug("  String: " + object.toString());
                    }
                    this.loadFile(object.toString());
                    dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                    return;
                }
            } else if (dataFlavor.getMimeType().equals("application/x-java-serialized-object; class=java.lang.String")) {
                try {
                    if (!bl) {
                        dropTargetDropEvent.acceptDrop(3);
                    }
                    bl = true;
                    object = transferable.getTransferData(object2[n]);
                }
                catch (Exception exception) {
                    Logger.errorEx(null, exception);
                }
                if (object instanceof String) {
                    String string = (String)object;
                    if (Logger.debugging) {
                        Logger.debug("  String: " + string);
                    }
                    if (string.startsWith("file:/")) {
                        this.loadFile(string);
                    } else {
                        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, FD_PROPERTY_INLINE, this.fd_oldFileName, string);
                        this.fd_propSupport.firePropertyChange(propertyChangeEvent);
                    }
                    dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                    return;
                }
            }
            ++n;
        }
        if (!bl) {
            dropTargetDropEvent.rejectDrop();
        }
    }
}

